%define _unpackaged_files_terminate_build 1
%define dist CPAN
Name: perl-%dist
Version: 2.28
Release: alt1

Summary: Download and build Perl modules from CPAN sites
License: GPLv2+ or Artistic-2.0
Group: Development/Perl

URL: %CPAN %dist
Source0: http://www.cpan.org/authors/id/A/AN/ANDK/%{dist}-%{version}.tar.gz

BuildArch: noarch

# avoid extra dependencies
%filter_from_requires /^perl.CPAN.Meta/d
%filter_from_requires /^perl.CPAN.SQLite/d
%filter_from_requires /^perl.Devel.Size/d

# https://bugzilla.altlinux.org/35062
Requires: perl(Digest/SHA.pm) perl(CPAN/Meta/Requirements.pm)

# Automatically added by buildreq on Thu Nov 10 2011
BuildRequires: gnupg perl-Archive-Tar perl-Archive-Zip perl-CPAN-Checksums perl-Expect perl-File-HomeDir perl-HTTP-Tiny perl-IO-Stty perl-Module-Build perl-Module-CoreList perl-Module-Pluggable perl-Module-Signature perl-Net-Ping perl-Parse-CPAN-Meta perl-Sort-Versions perl-Term-ReadKey perl-Test-Perl-Critic perl-Test-Pod perl-Test-Pod-Coverage perl-Text-Diff perl-Text-Glob perl-YAML perl-YAML-Syck perl-libwww

%description
The CPAN (Comprehensive Perl Archive Network) module is designed
to automate the make and install of perl modules and extensions.
It includes some searching capabilities and knows how to fetch
the raw data from the net.

%prep
%setup -q -n %{dist}-%{version}
rm -rv inc/

# XXX tests fail
rm t/30shell.t t/31sessions.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc	Changes README Todo
	%_bindir/cpan
	%_bindir/cpan-mirrors
	%_man1dir/cpan*
#dir	/etc/perl5/CPAN
#config(noreplace) %ghost /etc/perl5/CPAN/Config.pm
	%perl_vendor_privlib/App
	%perl_vendor_privlib/CPAN*

%changelog
