Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(DateTime/Locale.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-DateTime-Format-ICal
Version:        0.09
Release:        alt3_31
Summary:        Parse and format iCal datetime and duration strings
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/DateTime-Format-ICal
Source0:        https://cpan.metacpan.org/authors/id/D/DR/DROLSKY/DateTime-Format-ICal-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Module/Build.pm)
# Runtime
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DateTime/Event/ICal.pm)
BuildRequires:  perl(DateTime/Set.pm)
BuildRequires:  perl(DateTime/Span.pm)
BuildRequires:  perl(DateTime/TimeZone.pm)
BuildRequires:  perl(Params/Validate.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
# Tests only
BuildRequires:  perl(Test/More.pm)
Requires:       perl(DateTime.pm) >= 0.170
Requires:       perl(DateTime/Event/ICal.pm) >= 0.030
Requires:       perl(DateTime/Set.pm) >= 0.100
Requires:       perl(DateTime/TimeZone.pm) >= 0.220
Requires:       perl(Params/Validate.pm) >= 0.590




Source44: import.info
%filter_from_requires /^perl(DateTime.pm)/d
%filter_from_requires /^perl(DateTime.Event.ICal.pm)/d
%filter_from_requires /^perl(Params.Validate.pm)/d

%description
This module understands the ICal date/time and duration formats, as defined
in RFC 2445. It can be used to parse these formats in order to create the
appropriate objects.

%prep
%setup -q -n DateTime-Format-ICal-%{version}

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=%{buildroot} create_packlist=0
# %{_fixperms} %{buildroot}/*

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes TODO
%{perl_vendor_privlib}/*

%changelog
