Group: System/Servers
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Gearman-Server
Version:        1.130.1
Release:        alt1_11
Summary:        Function call router and load balancer
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Gearman-Server
Source0:        https://cpan.metacpan.org/authors/id/P/PA/PALIK/Gearman-Server-v%{version}.tar.gz
# Use absolute interpreter
Patch0:         Gearman-Server-v1.130.0-Do-not-use-usr-bin-env.patch
# Load IO::Socket::INET in Gearman/Server.pm
Patch1:         Gearman-Server-v1.130.1-Load-IO-Socket-INET.patch
BuildArch:      noarch
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Danga/Socket.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(fields.pm)
BuildRequires:  perl(Gearman/Util.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(Pod/Usage.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Sys/Hostname.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(version.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Script.pm)


Source44: import.info
%filter_from_requires /^perl(Danga.Socket.pm)/d

%description
You run a Gearman server (or more likely, many of them for both high-
availability and load balancing), then have workers (using Gearman::Worker
from the Gearman module, or libraries for other languages) register their
ability to do certain functions to all of them, and then clients (using
Gearman::Client, Gearman::Client::Async, etc) request work to be done from
one of the Gearman servers.

%prep
%setup -q -n Gearman-Server-v%{version}
%patch0 -p1
%patch1 -p1

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc CHANGES README.md
%{_bindir}/gearmand
%{perl_vendor_privlib}/Gearman
%{_mandir}/man1/gearmand.*

%changelog
