Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname perl-MooseX-ConfigFromFile
Name:           perl-MooseX-ConfigFromFile
Version:        0.14
Release:        alt3_23
License:        GPL+ or Artistic
Summary:        An abstract Moose role for setting attributes from a configfile
URL:            https://metacpan.org/release/MooseX-ConfigFromFile
Source:         https://cpan.metacpan.org/modules/by-module/MooseX/MooseX-ConfigFromFile-%{version}.tar.gz
BuildArch:      noarch
# Module Build
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Module/Build/Tiny.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  sed
# Module Runtime
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(MooseX/Types/Moose.pm)
BuildRequires:  perl(MooseX/Types/Path/Tiny.pm)
BuildRequires:  perl(namespace/autoclean.pm)
BuildRequires:  perl(warnings.pm)
# Test Suite
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(if.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/Deep.pm)
BuildRequires:  perl(Test/Fatal.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Requires.pm)
BuildRequires:  perl(Test/Without/Module.pm)
# Optional Test Requirements
BuildRequires:  perl(CPAN/Meta.pm)
BuildRequires:  perl(CPAN/Meta/Prereqs.pm)
BuildRequires:  perl(MooseX/Getopt.pm)
# Dependencies

# Avoid doc-file dependencies from tests

Source44: import.info

%description
This is an abstract role which provides an alternate constructor for
creating objects using parameters passed in from a configuration file. The
actual implementation of reading the configuration file is left to concrete
subroles.

It declares an attribute 'configfile' and a class method 'new_with_config',
and requires that concrete roles derived from it implement the class method
'get_config_from_file'.

Attributes specified directly as arguments to 'new_with_config' supersede
those in the configfile.

%prep
%setup -q -n MooseX-ConfigFromFile-%{version}

# Fix shellbangs in tests to placate rpmlint
sed -i '1s,#!perl,#!%{__perl},' t/*.t

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes CONTRIBUTING README t/
%{perl_vendor_privlib}/MooseX/

%changelog
