%define module Object-Pluggable

Name: perl-%module
Version: 1.29
Release: alt1

Summary: A base class for creating plugin-enabled objects

License: Artistic
Group: Development/Perl
Url: http://www.cpan.org

BuildArch: noarch
Source: %module-%version.tar.gz

# Automatically added by buildreq on Mon Nov 22 2010
BuildRequires: perl-Pod-Parser perl-Task-Weaken perl-devel

%description
Object::Pluggable is a base class for creating plugin enabled objects.
It is a generic port of POE::Component::IRC's plugin system.

If your object dispatches events to listeners, then Object::Pluggable
may be a good fit for you.

Basic use would involve subclassing Object::Pluggable, then overriding
"_pluggable_event()" and inserting "_pluggable_process()" wherever you
dispatch events from.

Users of your object can then load plugins using the plugin methods
provided to handle events generated by the object.

You may also use plugin style handlers within your object as
"_pluggable_process()" will attempt to process any events with local
method calls first. The return value of these handlers has the same
significance as the return value of 'normal' plugin handlers.

%prep
%setup -q -n %module-%version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/Object/*

%changelog
