%define upstream_name    Parse-EDID
%define upstream_version 1.0.7

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2

Summary:    Extended display identification data (EDID) parser
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/Parse/%{upstream_name}-%{upstream_version}.tar.gz
BuildRequires: perl(Test/Warn.pm)
BuildArch: noarch

BuildRequires(pre): rpm-build-perl
BuildRequires: perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)

%description
This module provides some function to parse Extended Display Identification
Data binary data structures.

Extended Display Identification Data (EDID) is a metadata format for
display devices to describe their capabilities to a video source. The
data format is defined by a standard published by the Video Electronics
Standards Association (VESA).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
rm t/kwalite.t

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make test

%install
%makeinstall_std

%files
%doc README META.yml META.json Changes
%perl_vendor_privlib/*

%changelog
