%define php_extension	xdebug

Name: php%_php_suffix-%php_extension
Version: 3.4.1
Epoch: 1
Release: alt1.%_php_release_version
Summary: xdebug extensions
Group: System/Servers
License: Xdebug-1.02
URL: https://xdebug.org/download#releases
VCS: https://github.com/xdebug/xdebug
Source: php-%php_extension-%version.tar
Source1: php-%php_extension.ini
Source2: php-%php_extension-params.sh

BuildRequires(pre): rpm-build-php8.1-version
BuildRequires: php-devel = %php_version
BuildRequires: php%_php_suffix = %php_version

%description
Xdebug is an extension for PHP to assist with debugging and development.
It contains a single step debugger to use with IDEs;
it upgrades PHP's var_dump() function;
it adds stack traces for Notices, Warnings, Errors and Exceptions;
it features functionality for recording every function call and
variable assignment to disk; it contains a profiler;
and it provides code coverage functionality for use with PHPUnit.

%prep
%setup -n php-%php_extension-%version
%build
phpize

BUILD_HAVE=`echo %php_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php_version
%configure \
	--with-%php_extension=%_usr
%php_make

%install
install -D -m 644 modules/xdebug.so %buildroot%php_extdir/xdebug.so
install -D -m 644 %SOURCE1 %buildroot%php_extconf/%php_extension/config
install -D -m 644 %SOURCE2 %buildroot%php_extconf/%php_extension/params

%files
%php_extconf/%php_extension
%php_extdir/xdebug.so

%post
%php_extension_postin

%preun
%php_extension_preun

%changelog
