%def_with vv
%def_with krb5
%def_enable purple
%def_enable telepathy

Name: pidgin-sipe
Version: 1.25.0
Release: alt1
Summary: Pidgin plugin for connecting to MS Communications Server

Group: Networking/Instant messaging
License: GPLv2+
Url: http://sipe.sourceforge.net/
Packager: Alexey Shabalin <shaba@altlinux.ru>

Source: %name-%version.tar
# Patch1: %name-%version-git_snapshot.patch

Requires: pidgin
Requires: gst-plugins-nice1.0 farstream0.2 gst-plugins-good1.0
Requires: gssntlmssp

BuildRequires: intltool
BuildRequires: pkgconfig(glib-2.0) >= 2.18.0 pkgconfig(gmodule-2.0) pkgconfig(gio-2.0) >= 2.32.0
BuildRequires: pkgconfig(gmime-3.0) >= 3.0.0
BuildRequires: pkgconfig(nss)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(purple) >= 2.8.0
BuildRequires: flex
%{?_with_vv:BuildRequires: pkgconfig(nice) >= 0.1.0 pkgconfig(gstreamer-1.0) pkgconfig(gstreamer-rtp-1.0) pkgconfig(farstream-0.2)}
%{?_with_krb5:BuildRequires: libkrb5-devel gssntlmssp-devel}
%{?_enable_telepathy:BuildRequires: pkgconfig(dbus-glib-1) pkgconfig(telepathy-glib) >= 0.18.0 pkgconfig(gobject-2.0)}
BuildRequires: pkgconfig(dbus-1)

%description
A third-party plugin for the Pidgin multi-protocol instant messenger.
It implements the extended version of SIP/SIMPLE used by various products:

    * Skype for Business
    * Microsoft Office 365
    * Microsoft Business Productivity Online Suite (BPOS)
    * Microsoft Lync Server
    * Microsoft Office Communications Server (OCS 2007/2007 R2)
    * Microsoft Live Communications Server (LCS 2003/2005)

With this plugin you should be able to replace your Microsoft Office
Communicator client with Pidgin.

%package -n telepathy-sipe
Summary: Telepathy connection manager to connect to MS Office Communicator
Group: Networking/Instant messaging
Requires: gssntlmssp
Requires: gst-plugins-nice1.0

%description -n telepathy-sipe
A Telepathy connection manager that implements the extended version of
SIP/SIMPLE used by various products:

    * Skype for Business
    * Microsoft Office 365
    * Microsoft Business Productivity Online Suite (BPOS)
    * Microsoft Lync Server
    * Microsoft Office Communications Server (OCS 2007/2007 R2)
    * Microsoft Live Communications Server (LCS 2003/2005)

This package provides the protocol support for Telepathy clients.

%prep
%setup -q
# %patch1 -p1

%build
%autoreconf
%configure \
	--disable-quality-check \
	--disable-static \
	%{subst_enable purple} \
	%{subst_enable telepathy} \
	%{subst_with vv} \
	%{subst_with krb5}

%make_build

%install
%makeinstall_std
rm -f %buildroot%_libdir/purple-2/*.la
%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog COPYING NEWS README TODO
%_libdir/purple-2/libsipe.so
%_pixmapsdir/pidgin/protocols/*/sipe.*
%_datadir/metainfo/%name.metainfo.xml

%files -n telepathy-sipe
%_libexecdir/telepathy-sipe
%_datadir/dbus-1/services/*.service
%_datadir/empathy/icons/hicolor/*/apps/im-sipe.*
%_datadir/telepathy/profiles/sipe.profile

%changelog
