%define rname plasma-nm
%def_disable libreswan

Name: plasma5-nm
Version: 5.27.11
Release: alt2
Epoch: 1
%K5init

Group: Graphical desktop/KDE
Summary: KDE Workspace 5 Plasma applet written in QML for managing network connections
Url: http://www.kde.org
License: GPL-2.0-or-later

Requires: NetworkManager-daemon
Requires: NetworkManager-adsl NetworkManager-wifi
Requires: mobile-broadband-provider-info
Requires: qca-qt5-ossl
#Requires: wireguard-tools

Provides: kf5-plasma-nm = %EVR
Obsoletes: kf5-plasma-nm < %EVR

Source: %rname-%version.tar
Source1: plasmanetworkmanagement-kded-ru-add.po
Source10: 01-plasma-nm.js
# ALT
Patch11: alt-old-openconnectauth.patch
Patch12: alt-def-allow-all.patch
Patch13: alt-explain-password-request.patch
Patch14: alt-revert.patch
Patch15: alt-add-bond-xor-mode.patch

# Automatically added by buildreq on Tue Mar 03 2015 (-bi)
# optimized out: cmake cmake-modules elfutils glib2-devel kf5-kdoctools-devel libEGL-devel libGL-devel libcloog-isl4 libgio-devel libjson-c libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-printsupport libqt5-qml libqt5-quick libqt5-svg libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libxcbutil-keysyms pkg-config python-base qt5-base-devel ruby ruby-stdlibs
#BuildRequires: ModemManager-devel extra-cmake-modules gcc-c++ kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdeclarative-devel kf5-kdelibs4support kf5-kdelibs4support-devel kf5-kdesignerplugin-devel kf5-kdoctools kf5-kdoctools-devel kf5-kemoticons-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-knotifications-devel kf5-kpackage-devel kf5-kparts-devel kf5-kservice-devel kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-libmm-qt-devel kf5-networkmanager-qt-devel kf5-plasma-framework-devel kf5-solid-devel kf5-sonnet-devel libnm-devel libopenconnect-devel python-module-google qt5-declarative-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5
BuildRequires: extra-cmake-modules gcc-c++ qt5-declarative-devel qt5-tools-devel-static
BuildRequires: mobile-broadband-provider-info libqca-qt5-devel
BuildRequires: ModemManager-devel libopenconnect-devel
BuildRequires: libnm-devel
BuildRequires: kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcodecs-devel kf5-kcompletion-devel
BuildRequires: kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel
BuildRequires: kf5-kdeclarative-devel kf5-kdesignerplugin-devel
#kf5-kdelibs4support kf5-kdelibs4support-devel
BuildRequires: kf5-kdoctools kf5-kdoctools-devel
BuildRequires: kf5-kemoticons-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel
BuildRequires: kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel kf5-kjobwidgets-devel
BuildRequires: kf5-knotifications-devel kf5-kpackage-devel kf5-kparts-devel kf5-kservice-devel kf5-ktextwidgets-devel
BuildRequires: kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel
BuildRequires: kf5-kxmlgui-devel kf5-plasma-framework-devel
BuildRequires: kf5-solid-devel kf5-sonnet-devel
BuildRequires: kf5-modemmanager-qt-devel kf5-networkmanager-qt-devel kf5-kcmutils-devel

%description
Plasma applet and editor for managing your network connections in KDE using
the default NetworkManager service.

%package maxi
Group: Graphical desktop/KDE
Summary: %name maximum package
BuildArch: noarch
Requires: %name
Requires: %name-connect-mobile
Requires: %name-connect-openvpn
Requires: %name-connect-fortisslvpn
Requires: %name-connect-vpnc
Requires: %name-connect-openconnect
Requires: %name-connect-libreswan
Requires: %name-connect-strongswan
Requires: %name-connect-iodine
Requires: %name-connect-l2tp
Requires: %name-connect-pptp
Requires: %name-connect-sstp
Requires: %name-connect-ssh
Provides: kf5-plasma-nm-maxi = %EVR
Obsoletes: kf5-plasma-nm-maxi < %EVR
%description maxi
%summary.

%package connect-mobile
Group: Graphical desktop/KDE
Summary: Mobile support for %name
BuildArch: noarch
Requires: %name
Requires: ModemManager NetworkManager-bluetooth NetworkManager-wwan mobile-broadband-provider-info
Provides: kf5-plasma-nm-connect-mobile = %EVR
Obsoletes: kf5-plasma-nm-connect-mobile < %EVR
%description connect-mobile
%summary.

%package connect-openvpn
Group: Graphical desktop/KDE
Summary: OpenVPN support for %name
Requires: %name
Requires: NetworkManager-openvpn
Provides: kf5-plasma-nm-connect-openvpn = %EVR
Obsoletes: kf5-plasma-nm-connect-openvpn < %EVR
%description connect-openvpn
%summary.

%package connect-fortisslvpn
Group: Graphical desktop/KDE
Summary: Fortinet SSLVPN support for %name
Requires: %name
Provides: kf5-plasma-nm-connect-fortisslvpn = %EVR
Obsoletes: kf5-plasma-nm-connect-fortisslvpn < %EVR
%description connect-fortisslvpn
%summary.

%package connect-vpnc
Group: Graphical desktop/KDE
Summary: Vpnc support for %name
Requires: %name
Requires: NetworkManager-vpnc
Provides: kf5-plasma-nm-connect-vpnc = %EVR
Obsoletes: kf5-plasma-nm-connect-vpnc < %EVR
%description connect-vpnc
%summary.

%package connect-openconnect
Group: Graphical desktop/KDE
Summary: OpenConnect support for %name
Requires: %name
Requires: NetworkManager-openconnect
Provides: kf5-plasma-nm-connect-openconnect = %EVR
Obsoletes: kf5-plasma-nm-connect-openconnect < %EVR
%description connect-openconnect
%summary.

%package connect-iodine
Group: Graphical desktop/KDE
Summary: Iodine DNS tunnel support for %name
Requires: %name
Requires: NetworkManager-iodine
Provides: kf5-plasma-nm-connect-iodine = %EVR
Obsoletes: kf5-plasma-nm-connect-iodine < %EVR
%description connect-iodine
%summary.

%package connect-libreswan
Group: Graphical desktop/KDE
Summary: Openswan support for %name
Requires: %name
%if_enabled libreswan
Requires: NetworkManager-libreswan
%endif
Obsoletes: plasma5-nm-connect-openswan < %EVR
%description connect-libreswan
%summary.

%package connect-strongswan
Group: Graphical desktop/KDE
Summary: Strongswan support for %name
Requires: %name
Requires: NetworkManager-strongswan
Provides: kf5-plasma-nm-connect-strongswan = %EVR
Obsoletes: kf5-plasma-nm-connect-strongswan < %EVR
%description connect-strongswan
%summary.

%package connect-l2tp
Group: Graphical desktop/KDE
Summary: L2TP support for %name
Requires: %name
Requires: NetworkManager-l2tp
Provides: kf5-plasma-nm-connect-l2tp = %EVR
Obsoletes: kf5-plasma-nm-connect-l2tp < %EVR
%description connect-l2tp
%summary.

%package connect-pptp
Group: Graphical desktop/KDE
Summary: PPTP support for %name
Requires: %name
Requires: NetworkManager-pptp
Provides: kf5-plasma-nm-connect-pptp = %EVR
Obsoletes: kf5-plasma-nm-connect-pptp < %EVR
%description connect-pptp
%summary.

%package connect-sstp
Group: Graphical desktop/KDE
Summary: SSTP support for %name
Requires: %name
Requires: NetworkManager-sstp
Provides: kf5-plasma-nm-connect-sstp = %EVR
Obsoletes: kf5-plasma-nm-connect-sstp < %EVR
%description connect-sstp
%summary.

%package connect-ssh
Group: Graphical desktop/KDE
Summary: SSH support for %name
Requires: %name
Requires: ssh-provider-openssh-clients NetworkManager-ssh
Provides: kf5-plasma-nm-connect-ssh = %EVR
Obsoletes: kf5-plasma-nm-connect-ssh < %EVR
%description connect-ssh
%summary.

%prep
%setup -n %rname-%version
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

cat %SOURCE1 >> po/ru/plasmanetworkmanagement-kded.po

%build
%K5build

%install
%K5install
%K5install_move data kcm_networkmanagement

install -m0644 -p -D %SOURCE10 %buildroot/%_K5data/plasma/updates/01-plasma-nm.js

%find_lang %name --all-name

%files -f %name.lang
%dir %_K5plug/plasma/network/
%dir %_K5plug/plasma/network/vpn/
%doc LICENSES/*
%_K5lib/libplasmanm_*.so
%_K5plug/kf5/kded/networkmanagement.so
%_K5plug/plasma/kcms/systemsettings_qwidgets/*networkmanagement*.so
%_K5qml/org/kde/plasma/networkmanagement/
%_K5xdgapp/*networkmanagement*.desktop
%_K5data/*networkmanagement/
%_kf5_data/plasma/plasmoids/org.kde.plasma.networkmanagement/
%_K5data/plasma/updates/*nm*
%_K5notif/networkmanagement.notifyrc
%_datadir/qlogging-categories5/*.*categories
%_datadir/metainfo/*.xml

%files maxi
%files connect-mobile

%files connect-iodine
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_iodineui.so
%files connect-openvpn
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_openvpnui.so
%files connect-fortisslvpn
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_fortisslvpnui.so
%files connect-vpnc
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_vpncui.so
%files connect-openconnect
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_openconnect_*.so
%files connect-libreswan
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_libreswanui.so
%files connect-strongswan
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_strongswanui.so
%files connect-l2tp
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_l2tpui.so
%files connect-pptp
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_pptpui.so
%files connect-sstp
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_sstpui.so
%files connect-ssh
%_K5plug/plasma/network/vpn/plasmanetworkmanagement_sshui.so

%changelog
