%def_disable hal 

Name: pmount
Version: 0.9.23
Release: alt2

Summary: Automounter tool for HAL/dbus
License: GPL
Group: Monitoring

Url: http://pmount.alioth.debian.org/

Source0: %name-%version.tar.gz

Source3: %name.control

Patch0: pmount-0.9.16-alt-makefile.patch
Patch2: pmount-0.9.17-alt-floppy.patch
Patch3: pmount-0.9.23-alt-natspec.patch

Requires: mount

Packager: Afanasov Dmitry <ender@altlinux.org>

%{?_enable_hal:BuildRequires: libhal-devel >= 0.5.7}
BuildRequires: libdbus-devel >= 0.94, libsysfs-devel, pkgconfig, intltool, libblkid-devel
PreReq: control

# hack for build in hasher
BuildPreReq: glib2-devel

# Automatically added by buildreq on Wed Aug 29 2007
BuildRequires: gcc-c++ libnatspec-devel libsysfs-devel perl-XML-Parser

%description
pmount allows unprivileged users to mount replaceable media USB, FireWire and
PCMCIA without record in /etc/fstab. It creates powerful system of automounting
as project GNOME Utopia, and limits volume of a code which should be carried
out with the rights root up to a minimum. Version 0.9 includes also integration
with cryptsetup for transparent connection crypto devices.

%description -l ru_RU.UTF8
pmount позволяет непривигелированным пользователям подключать(монтировать)
сменные носители USB, FireWire и PCMCIA без записи в /etc/fstab. Это создает
мощную систему автомонтирования, как проект GNOME Utopia, и ограничивает объем
кода, который должен выполняться с правами  root до минимума. Версия 0.9
включает также интеграцию с cryptsetup для прозрачного подключения криптованых
устройств.

%package hal
Summary: HAL-aware wrapper around pmount
Group: Monitoring

Requires: pmount

%description hal
pmount-hal extends pmount by making it work together with hal (Hardware
Abstration Layer).

%prep
%setup -q
%patch0 -p1
%patch2 -p1
%patch3 -p1

%build
%autoreconf
%configure \
	--with-media-dir=/media/ \
	--with-lock-dir=/var/lock/pmount/ \
	--with-whitelist=/etc/pmount.allow \
	--with-mount-prog=/bin/mount \
	--with-umount-prog=/bin/umount \
	--with-cryptsetup-prog=/usr/sbin/cryptsetup \
	%{subst_enable hal} \
	--with-natspec
%make_build

%install
%make_install DESTDIR=%buildroot install
%__install -pD -m755 %SOURCE3 %buildroot%_controldir/%name

%find_lang %name

%pre
%pre_control pmount

%post
%post_control -s restricted pmount

%files -f %name.lang
%doc AUTHORS ChangeLog README.devel TODO
%config(noreplace) %_sysconfdir/pmount.allow
%_controldir/%name
%attr(700,root,root) %_bindir/p*mount
%_man1dir/pmount.1*
%_man1dir/pumount.1*

%if_enabled hal
%files hal
%_bindir/pmount-hal
%_man1dir/pmount-hal.1*
%endif


%changelog
