Name: procps
Version: 3.3.17
Release: alt7.g37f1060.p10.2

%def_disable bootstrap
%if_enabled bootstrap
%force_without systemd
%force_disable check
%else
%def_with systemd
%endif

Summary: System and process monitoring utilities
License: GPLv2+ and LGPLv2+
Group: Monitoring
URL: https://gitlab.com/procps-ng/procps

# git://git.altlinux.org/gears/p/procps.git
Vcs: https://gitlab.com/procps-ng/procps.git
Source: %name-%version-%release.tar

# it is actually procps-ng
Provides: procps-ng = %version-%release

Requires: lib%name = %version-%release

# Due to kill(1) relocation to coreutils.
Requires: coreutils >= 0:5.2.1-alt2

BuildRequires: libncursesw-devel
%if_with systemd
BuildRequires: libsystemd-devel
%endif
%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu}}

%define _unpackaged_files_terminate_build 1

%description
This package contains a set of system utilities which provide system
information.  procps includes: free, pgrep, pkill, pmap, ps, pwdx,
skill, slabtop, snice, sysctl, tload, top, uptime, vmstat, w, watch.

%package -n lib%name
Summary: %name shared library
License: LGPLv2+
Group: System/Libraries

%package -n lib%name-devel
Summary: Development files for building %name-aware applications
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name
This package contains lib%name runtime library.

%description -n lib%name-devel
This package contains development files for building %name-aware
applications.

%prep
%setup -n %name-%version-%release

# build scripts expect to find package version in this file
echo -n %version-%release > .tarball-version

%build
%add_optflags "-Werror"
%ifarch %e2k
# lcc 1.26.20 barfs on ncurses_colors (mcst#8106)
%add_optflags "-Wno-error=unused-but-set-variable"
%endif
./autogen.sh
%configure \
	--exec-prefix=/ \
	--sbindir=/sbin \
	--enable-watch8bit \
	--disable-static \
	--disable-kill \
	--enable-skill \
	--disable-pidof \
	--disable-nls \
	--disable-modern-top \
	%{subst_with systemd} \
	#
%make_build

%install
%makeinstall_std
rm -r %buildroot%_docdir/procps-ng

# move ps to /bin
mkdir -p %buildroot/bin
mv %buildroot%_bindir/ps %buildroot/bin/

# reduce redundancy
ln -snf pgrep %buildroot%_bindir/pkill
ln -snf pgrep %buildroot%_bindir/pidwait
ln -snf skill %buildroot%_bindir/snice

# relocate shared libraries from %_libdir/ to /%_lib/
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%check
make check

%files
/bin/*
/sbin/*
%_bindir/*
%_mandir/man?/*
%doc AUTHORS Documentation/bugs.md Documentation/FAQ NEWS README.md top/README.top Documentation/TODO

%files -n lib%name
/%_lib/*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%changelog
