%define ver 1.3.6

Name: proftpd
Version: %ver
Release: alt0.4.ga73dbfe3b

%define _libexecdir %{expand:%_libdir}
%def_disable tests

%define def_shared() %{expand:%{?1:%%global mod_shared_list %{?mod_shared_list:%mod_shared_list:}%*}}%{expand:%%global _shared_%1 1}%{expand:%%global _with_%1 1}
%define def_static() %{expand:%{?1:%%global mod_static_list %{?mod_static_list:%mod_static_list:}%*}}%{expand:%%global _static_%1 1}%{expand:%%global _with_%1 1}

%def_static mod_auth_pam
%def_static mod_readme

%def_shared mod_ctrls_admin
%def_shared mod_ifsession
%def_shared mod_ldap
%def_shared mod_quotatab
%def_shared mod_quotatab_file
%def_shared mod_quotatab_ldap
%def_shared mod_quotatab_sql
%def_shared mod_radius
%def_shared mod_ratio
%def_shared mod_rewrite
%def_shared mod_site_misc
%def_shared mod_sql
%def_shared mod_sql_mysql
#def_shared mod_sql_odbc
%def_shared mod_sql_passwd
%def_shared mod_sql_postgres
%def_shared mod_sql_sqlite
%def_shared mod_tls
%def_shared mod_tls_shmcache
%def_shared mod_tls_memcache
%def_shared mod_facl
%def_shared mod_load
%def_shared mod_sftp
%def_shared mod_sftp_pam
%def_shared mod_sftp_sql
%def_shared mod_ban
%def_shared mod_dynmasq
%def_shared mod_exec
%def_shared mod_shaper
%def_shared mod_unique_id
#def_shared mod_wrap2
#def_shared mod_wrap2_file
#def_shared mod_wrap2_sql

Summary: ProFTPd -- Professional FTP Server
License: GPL
Group: System/Servers
Url: http://www.%name.org/

Source: %name-%ver.tar
Source1: %name.logrotate
Source2: %name.xinetd
Source3: %name.init
Source4: %name.pamd
Source5: %name-control
Source6: %name.conf

Patch1: %name-man.patch
Patch2: %name-1.3.3rc1-alt-pkgconfig-prefix.patch
Patch4: %name-ldap-config.patch
Patch5: %name-1.2.10-iconv.patch
Patch6: %name-1.3.2rc1-mod_sql_mysql.patch
Patch7: %name-1.3.6-mod_sql_postgres.patch
Patch9: %name-1.3.0-alt-ltdl.patch
Patch10: %name-1.3.6-inc-pcre.patch
Patch11: %name-1.3.5-alt-mysql8-transition.patch

# Debian patches
Patch50: %name-deb-change_pam_name.patch
Patch51: %name-deb-core_create-home.patch

# Upstream security fixes
Patch100: upstream-fix-for-CVE-2019-18217.patch
Patch101: upstream-fix-for-CVE-2019-19269-and-CVE-2019-19270.patch
Patch102: upstream-fix-for-CVE-2020-9272.patch
Patch103: upstream-fix-for-CVE-2020-9273.patch

Provides: ftpserver
Requires: locale-en
PreReq: anonftp
AutoReq: yes, noshell, noperl

Packager: Afanasov Dmitry <ender@altlinux.org>

BuildRequires: gcc-c++ libncurses-devel libtinfo-devel zlib-devel libltdl-devel libpcre-devel
# ftpmail findreq
BuildRequires: perl-Mail-Sendmail
BuildRequires: libcap-devel

%{?_with_mod_auth_pam:BuildRequires: pam-devel}

%{?_with_mod_sql_mysql:BuildRequires: libMySQL-devel}
%{?_with_mod_ldap:BuildRequires: libldap-devel}
%{?_with_mod_sql_postgres:BuildRequires: libpq-devel postgresql-devel}
%{?_with_mod_tls:BuildRequires: libssl-devel}
%{?_with_mod_tls_memcache:BuildRequires: libmemcached-devel}
%{?_with_mod_facl:BuildRequires: libacl-devel}
%{?_with_mod_sql_sqlite:BuildRequires: libsqlite3-devel}
%{?_with_mod_facl:BuildRequires: libacl-devel}

%description
ProFTPd is an enhanced FTP server with a focus toward simplicity, security,
and ease of configuration.  It features a very Apache-like configuration
syntax, and a highly customizable server infrastructure, including support for
multiple 'virtual' FTP servers, anonymous FTP, and permission-based directory
visibility.

This package will setup ProFTPd for both inetd and standalone operations.

%package -n %name-mod_ctrls_admin
Summary: Module implementing admin control handlers
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_ifsession
Summary: Module supporting conditional per-user/group/class configuration contexts
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_ldap
Summary: LDAP password lookup module for ProFTPD
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_quotatab
Summary: Module for managing FTP byte/file quotas via centralized tables
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_quotatab_file
Summary: Sub-module for managing quota data via file-based tables
Group: System/Servers
Requires: %name-mod_quotatab = %version-%release

%package -n %name-mod_quotatab_ldap
Summary: Sub-module for obtaining quota information from an LDAP directory
Group: System/Servers
Requires: %name-mod_quotatab = %version-%release

%package -n %name-mod_quotatab_sql
Summary: Sub-module for managing quota data via SQL-based tables
Group: System/Servers
Requires: %name-mod_quotatab = %version-%release

%package -n %name-mod_radius
Summary: Module for RADIUS authentication and accounting
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_ratio
Summary: Support upload/download ratios
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_rewrite
Summary: Module for rewriting FTP commands
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_site_misc
Summary: Module implementing miscellaneous SITE commands
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_sql
Summary: SQL frontend
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_sql_passwd
Summary: Enables support for some of OpenSSL password formats
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_sql_mysql
Summary: Support for connecting to MySQL databases
Group: System/Servers
Requires: %name-mod_sql = %version-%release

%package -n %name-mod_sql_postgres
Summary: Support for connecting to Postgres databases
Group: System/Servers
Requires: %name-mod_sql = %version-%release

%package -n %name-mod_tls
Summary: An RFC2228 SSL/TLS module for ProFTPD
Group: System/Servers
Requires: %name = %version-%release


%package -n %name-mod_facl
Summary: POSIX ACL checking code (aka POSIX.1e hell)
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_ban
Summary: A ProFTPD module implementing ban lists using the Controls API
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_dynmasq
Summary: A ProFTPD module for DynDNS configurations
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_load
Summary: System load handling module for ProFTPD
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_sftp
Summary: A ProFTPD module implementing sftp server
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_sftp_pam
Summary: PAM authorization for mod_sftp ProFTPD sub-module
Group: System/Servers
Requires: %name-mod_sftp = %version-%release

%package -n %name-mod_sftp_sql
Summary: SQL authorization for mod_sftp ProFTPD sub-module
Group: System/Servers
Requires: %name-mod_sftp = %version-%release

%package -n %name-mod_sql_sqlite
Summary: Support for using SQLite databases
Group: System/Servers
Requires: %name-mod_sql = %version-%release

%package -n %name-mod_tls_shmcache
Summary: Implements shared SSL session cache
Group: System/Servers
Requires: %name-mod_tls = %version-%release

%package -n %name-mod_tls_memcache
Summary: Implements shared SSL/TLS session cache in memcache
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_exec
Summary: Executes external scripts
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_shaper
Summary: Implements rate throttling
Group: System/Servers
Requires: %name = %version-%release

%package -n %name-mod_unique_id
Summary: Generates unique ids
Group: System/Servers
Requires: %name = %version-%release


%package -n %name-control
Summary: ProFTPD control facility
Group: System/Servers
Requires: %name = %version-%release
Buildarch: noarch

%package -n %name-devel
Summary: ProFTPD development header files
Group: System/Servers
Requires: %name = %version-%release

%description -n %name-mod_ctrls_admin
This module implements administrative control actions for the ftpdctl program.

%description -n %name-mod_ifsession
Module supporting conditional per-user/group/class configuration contexts

%description -n %name-mod_ldap
LDAP password lookup module for ProFTPD

%description -n %name-mod_quotatab
Module for managing FTP byte/file quotas via centralized tables

%description -n %name-mod_quotatab_file
Sub-module for managing quota data via file-based tables

%description -n %name-mod_quotatab_ldap
Sub-module for obtaining quota information from an LDAP directory

%description -n %name-mod_quotatab_sql
Sub-module for managing quota data via SQL-based tables

%description -n %name-mod_radius
Module for RADIUS authentication and accounting

%description -n %name-mod_ratio
Support upload/download ratios

%description -n %name-mod_rewrite
Module for rewriting FTP commands

%description -n %name-mod_site_misc
Module implementing miscellaneous SITE commands

%description -n %name-mod_sql
SQL frontend

%description -n %name-mod_sql_passwd
The mod_sql_passwd module provides support for some password formats, which are
not supported by mod_sql. Such as MD5 or SHA1 passwords, base64-encoded or
hex-encoded, without the prefix which is required by mod_sql's "OpenSSL" SQLAuthType. 
   
When the mod_sql_passwd module is enabled, you can configure SQLAuthTypes of
"MD5", "SHA1", "SHA256", or "SHA512", as well as the existing types supported
by mod_sql. 

%description -n %name-mod_sql_mysql
Support for connecting to MySQL databases

%description -n %name-mod_sql_postgres
Support for connecting to Postgres databases

%description -n %name-mod_tls
An RFC2228 SSL/TLS module for ProFTPD

%description -n %name-mod_facl
POSIX ACL checking code (aka POSIX.1e hell)

%description -n %name-mod_ban
Module implementing ban lists using the Controls API

%description -n %name-mod_dynmasq
Module for dynamically updating MasqueradeAddress configurations, as when
DynDNS names are used

%description -n %name-mod_load
Module for refusing connections based on system load

%description -n %name-mod_sftp
SFTP server implementation

%description -n %name-mod_sftp_pam
SFTP PAM authentication.

%description -n %name-mod_sftp_sql
SFTP SQL authentication.

%description -n %name-mod_sql_sqlite
SQLite backend.

%description -n %name-mod_tls_shmcache
Module which provides a shared SSL session cache using SysV shared memory

%description -n %name-mod_tls_memcache
Module which provides a shared SSL session cache in a memcached server

%description -n %name-mod_exec
Module for executing external scripts

%description -n %name-mod_shaper
Module implementing daemon-wide rate throttling via IPC

%description -n %name-mod_unique_id
Module for generating a unique ID for each FTP session.

%description -n %name-devel
ProFTPD development header files

%description -n %name-control
This package contains control rules for proftpd - Professional FTP Daemon

See control(8) for details.

%prep
%setup -q -n %name-%ver
%patch1 -p2
%patch2 -p1
%patch4 -p1
#patch5 -p1
%patch6 -p1
%patch7 -p2
#%%patch9 -p1
%patch10 -p2
%patch11 -p0

# debian patches
%patch50 -p1
%patch51 -p1

# Upstream security fixes
%patch100 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1

%build
#__libtoolize --ltdl
%__autoconf
%configure \
        %{?_enable_debug:--enable-devel} \
        %{?_enable_tests:--enable-tests} \
        --libexecdir=%_libexecdir/%name \
        --with-pkgconfig=%_pkgconfigdir \
        --localstatedir=/var/lib/proftpd \
        --enable-auth-pam \
        --enable-ctrls \
        --enable-largefile \
        --disable-rpath \
        --enable-autoshadow --enable-sendfile --enable-dso \
        --with-lastlog=/var/log/lastlog \
        --enable-openssl \
        --enable-nls \
        --enable-facl \
        --enable-memcache \
        --enable-pcre \
        --with-modules=%mod_static_list \
        --with-shared=%mod_shared_list

subst 's|^\(/var/tmp/proftpd-buildroot\)=.*$|\1=no|' libtool

%make

%install
myname=`id -un`
mygroup=`id -gn`

%make_install install DESTDIR=%buildroot INSTALL_USER=$myname INSTALL_GROUP=$mygroup

install -pD -m640 %SOURCE4 %buildroot%_sysconfdir/pam.d/%name
install -p -m644 -D %SOURCE6 %buildroot%_sysconfdir/%name.conf
install -p -m644 -D %SOURCE1 %buildroot%_sysconfdir/logrotate.d/%name
install -p -m644 -D %SOURCE2 %buildroot%_sysconfdir/xinetd.d/%name
install -p -m755 -D %SOURCE3 %buildroot%_initdir/%name
install -m755 contrib/xferstats.holger-preiss %buildroot%_sbindir

chmod 711 %buildroot%_sbindir/%name

ln -s -f %name %buildroot%_sbindir/in.%name
ln -s -f %name %buildroot%_sbindir/in.ftpd

install -pD -m755 %SOURCE5 %buildroot%_controldir/%name

echo >>%buildroot%_sysconfdir/ftpusers <<EOF
root
bin
daemon
adm
lp
sync
shutdown
halt
mail
news
uucp
operator
games
nobody
EOF

mkdir -p %buildroot/var/log/%name
rm -f %buildroot%_libexecdir/%name/*.a

# create tmpfiles conf
mkdir -p %buildroot%_tmpfilesdir
cat >%buildroot%_tmpfilesdir/%name.conf<<END
d /run/proftpd 0750 root root -
END

mkdir -p -m0750 %buildroot/run/proftpd

%find_lang %name

%pre
if [ -e "%_controldir/%name" ]; then
    %pre_control %name
fi

%post
if grep -qe '^[[:blank:]]*CharsetLocal' %_sysconfdir/%name.conf; then
   echo "WARNING: iconv patch is disabled, do not use CharsetLocal/CharsetRemote" >&2
   echo "WARNING: see doc/modules/mod_lang.html for details" >&2
   echo "WARNING: autocommenting corresponding Options, please check" >&2
   subst 's/^\([[:blank:]]*CharsetLocal .*\)/# \1/' %_sysconfdir/%name.conf
   subst 's/^\([[:blank:]]*CharsetRemote .*\)/# \1/' %_sysconfdir/%name.conf
fi
if [ -e "%_controldir/%name" ]; then
    %post_control -s standalone %name
fi
%post_service %name

%preun
%preun_service %name

%files -f %name.lang
%doc README* ChangeLog INSTALL NEWS CREDITS doc/* contrib/README.*
%doc sample-configurations/* contrib/ftpasswd contrib/ftpquota
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/ftpusers
%config(noreplace) %_sysconfdir/pam.d/%name
%config(noreplace) %_initdir/%name
%config(noreplace) %_sysconfdir/xinetd.d/%name
%config(noreplace) %_sysconfdir/logrotate.d/%name
%_tmpfilesdir/%name.conf
%_sbindir/*
%_bindir/ftp*
%_man1dir/ftpasswd.*
%_man1dir/ftpmail.*
%_man1dir/ftpquota.*
%_man1dir/ftpwho.*
%_man1dir/ftpcount.*
%_man1dir/ftptop.*
%_man5dir/*
%_man8dir/%name.*
%_man8dir/ftpshut.*
%_man8dir/ftpdctl.*
%_man8dir/ftpscrub.*
%dir /var/lib/%name
%dir /var/log/%name
%dir %_libexecdir/%name

%ifdef _shared_mod_ctrls_admin
%files -n %name-mod_ctrls_admin
%_libexecdir/%name/mod_ctrls_admin.*
%endif

%ifdef _shared_mod_ifsession
%files -n %name-mod_ifsession
%_libexecdir/%name/mod_ifsession.*
%endif

%ifdef _shared_mod_ldap
%files -n %name-mod_ldap
%_libexecdir/%name/mod_ldap.*
%endif

%ifdef _shared_mod_quotatab
%files -n %name-mod_quotatab
%_libexecdir/%name/mod_quotatab.*
%endif

%ifdef _shared_mod_quotatab_file
%files -n %name-mod_quotatab_file
%_libexecdir/%name/mod_quotatab_file.*
%endif

%ifdef _shared_mod_quotatab_ldap
%files -n %name-mod_quotatab_ldap
%_libexecdir/%name/mod_quotatab_ldap.*
%endif

%ifdef _shared_mod_quotatab_sql
%files -n %name-mod_quotatab_sql
%_libexecdir/%name/mod_quotatab_sql.*
%endif

%ifdef _shared_mod_radius
%files -n %name-mod_radius
%_libexecdir/%name/mod_radius.*
%endif

%ifdef _shared_mod_ratio
%files -n %name-mod_ratio
%_libexecdir/%name/mod_ratio.*
%endif

%ifdef _shared_mod_rewrite
%files -n %name-mod_rewrite
%_libexecdir/%name/mod_rewrite.*
%endif

%ifdef _shared_mod_site_misc
%files -n %name-mod_site_misc
%_libexecdir/%name/mod_site_misc.*
%endif

%ifdef _shared_mod_sql
%files -n %name-mod_sql
%_libexecdir/%name/mod_sql.*
%endif

%ifdef _shared_mod_sql_passwd
%files -n %name-mod_sql_passwd
%_libexecdir/%name/mod_sql_passwd.*
%endif

%ifdef _shared_mod_sql_mysql
%files -n %name-mod_sql_mysql
%_libexecdir/%name/mod_sql_mysql.*
%endif

%ifdef _shared_mod_sql_postgres
%files -n %name-mod_sql_postgres
%_libexecdir/%name/mod_sql_postgres.*
%endif

%ifdef _shared_mod_tls
%files -n %name-mod_tls
%_libexecdir/%name/mod_tls.*
%endif

%ifdef _shared_mod_facl
%files -n %name-mod_facl
%_libexecdir/%name/mod_facl.*
%endif

%ifdef _shared_mod_ban
%files -n %name-mod_ban
%_libexecdir/%name/mod_ban.*
%endif

%ifdef _shared_mod_dynmasq
%files -n %name-mod_dynmasq
%_libexecdir/%name/mod_dynmasq.*
%endif

%ifdef _shared_mod_load
%files -n %name-mod_load
%_libexecdir/%name/mod_load.*
%endif

%ifdef _shared_mod_sftp
%files -n %name-mod_sftp
%_libexecdir/%name/mod_sftp.*
%_sysconfdir/blacklist.dat
%_sysconfdir/dhparams.pem
%endif

%ifdef _shared_mod_sftp_pam
%files -n %name-mod_sftp_pam
%_libexecdir/%name/mod_sftp_pam.*
%endif

%ifdef _shared_mod_sftp_sql
%files -n %name-mod_sftp_sql
%_libexecdir/%name/mod_sftp_sql.*
%endif

%ifdef _shared_mod_sql_sqlite
%files -n %name-mod_sql_sqlite
%_libexecdir/%name/mod_sql_sqlite.*
%endif

%ifdef _shared_mod_tls_shmcache
%files -n %name-mod_tls_shmcache
%_libexecdir/%name/mod_tls_shmcache.*
%endif

%ifdef _shared_mod_tls_memcache
%files -n %name-mod_tls_memcache
%_libexecdir/%name/mod_tls_memcache.*
%endif

%ifdef _shared_devel
%files -n %name-devel
%_libexecdir/%name/devel.*
%endif

%ifdef _shared_control
%files -n %name-control
%_libexecdir/%name/control.*
%endif

%ifdef _shared_mod_exec
%files -n %name-mod_exec
%_libexecdir/%name/mod_exec.*
%endif

%ifdef _shared_mod_shaper
%files -n %name-mod_shaper
%_libexecdir/%name/mod_shaper.*
%endif

%ifdef _shared_mod_unique_id
%files -n %name-mod_unique_id
%_libexecdir/%name/mod_unique_id.*
%endif


%files -n %name-devel
%_bindir/prxs
%_includedir/%name
%_pkgconfigdir/*

%files -n %name-control
%_controldir/%name

%changelog
