Name: pth
Version: 2.0.7
Release: alt6

Summary: The GNU Portable Threads library
License: LGPLv2+
Group: System/Libraries
Url: http://www.gnu.org/software/%name/
# ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
Source: %name-%version.tar

%define libname lib%name
%def_disable static

%description
Pth is a very portable POSIX/ANSI-C based library for Unix platforms
which provides non-preemptive priority-based scheduling for multiple
threads of execution ("multithreading") inside server applications.
All threads run in the same address space of the server application,
but each thread has it's own individual program-counter, run-time
stack, signal mask and errno variable.

%package -n %libname
Summary: The GNU Portable Threads runtime library
Group: System/Libraries
Provides: %name = %version-%release
Obsoletes: %name

%package -n %libname-devel
Summary: The GNU Portable Threads developement files
Group: Development/C
Requires: %libname = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel

%package -n %libname-devel-static
Summary: The GNU Portable Threads static library
Group: Development/C
Requires: %libname-devel = %version-%release
Provides: %name-devel-static = %version-%release

%description -n %libname
Pth is a very portable POSIX/ANSI-C based library for Unix platforms
which provides non-preemptive priority-based scheduling for multiple
threads of execution ("multithreading") inside server applications.
All threads run in the same address space of the server application,
but each thread has it's own individual program-counter, run-time
stack, signal mask and errno variable.

This package includes Pth runtime library.

%description -n %libname-devel
Pth is a very portable POSIX/ANSI-C based library for Unix platforms
which provides non-preemptive priority-based scheduling for multiple
threads of execution ("multithreading") inside server applications.
All threads run in the same address space of the server application,
but each thread has it's own individual program-counter, run-time
stack, signal mask and errno variable.

This package includes headers and other development files necessary
to build applications that use Pth.

%description -n %libname-devel-static
Pth is a very portable POSIX/ANSI-C based library for Unix platforms
which provides non-preemptive priority-based scheduling for multiple
threads of execution ("multithreading") inside server applications.
All threads run in the same address space of the server application,
but each thread has it's own individual program-counter, run-time
stack, signal mask and errno variable.

This package includes Pth static library.

%prep
%setup

%build
%configure --enable-shared %{subst_enable static}
# SMP-incompatible build
make

%install
%makeinstall_std

%check
make -k check

%files -n %libname
%doc ANNOUNCE AUTHORS COPYING NEWS README SUPPORT TESTS THANKS
%_libdir/*.so.*

%files -n %libname-devel
%_bindir/*
%_libdir/*.so
%_includedir/*
%_man1dir/*
%_man3dir/*
%_datadir/aclocal/*

%if_enabled static
%files -n %libname-devel-static
%_libdir/*.a
%endif	# enabled static

%changelog
