%define _unpackaged_files_terminate_build 1
#based on fedora spec
Name: pybind11
Version: 2.6.2
Release: alt2

Summary: Seamless operability between C++11 and Python
License: BSD-3-Clause
Group: Development/Other

Url: https://github.com/pybind/pybind11
Source: %name-%version.tar
Patch2000: alt-e2k-workaround-for-broken-tests.patch

BuildRequires(pre): rpm-build-python3
# Automatically added by buildreq on Thu May 10 2018
BuildRequires: boost-devel-headers
BuildRequires: catch-devel
BuildRequires: ccmake
BuildRequires: eigen3
BuildRequires: gcc-c++
BuildRequires: python3-dev
BuildRequires: python3-module-pytest
BuildRequires: python3-module-setuptools

# These are only needed for the checks
BuildRequires: python3-module-numpy
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-scipy
BuildRequires: eigen3-devel
BuildRequires: ctest

%package devel
Summary: %summary
Group: Development/Other
# For dir ownership
Requires: cmake

%package -n python3-module-%name
Summary: %summary
Group: Development/Python3
Requires: %name-devel = %EVR

%define base_description \
pybind11 is a lightweight header-only library that exposes C++ types in Python and vice versa, mainly to create Python bindings of existing C++ code. Tutorial and reference documentation is provided at http://pybind11.readthedocs.org/en/master

%description
%base_description

%description devel
%base_description

This package contains the development headers for pybind11.

%description -n python3-module-%name
%base_description

This package contains the Python 3 files.

%prep
%setup
%ifarch %e2k
%patch2000 -p1
%endif

%build
%define _cmake__builddir python3/BUILD
mkdir -p python3
%cmake -DCMAKE_BUILD_TYPE=Release -DPYTHON_EXECUTABLE=%_bindir/python3
%cmake_build

%python3_build_debug

%install
%define _cmake__builddir python3/BUILD
%cmake_install
# Force install to arch-ful directories instead.
PYBIND11_USE_CMAKE=true %python3_install "--install-purelib" "%python3_sitelibdir"

rm -rf %buildroot%_includedir/python*

%check
%ifarch %e2k
export SKIP_E2K=1
%endif
%define _cmake__builddir python3/BUILD/tests
%cmake_build --target check

%files devel
%doc README.rst LICENSE docs/*
%_includedir/%name
%_datadir/cmake/%name
%_bindir/%name-config

%files -n python3-module-%name
%python3_sitelibdir/%name
%python3_sitelibdir/%name-%version-*.egg-info

%changelog
