%define packagename python3-module-pymunk

Name: pymunk
Version: 6.0.0
Release: alt1

Summary: Empty package %packagename
License: MIT
Group: Development/Python3

Source: %name-%version.zip
Patch: pymunk-6.0.0-mockdoc.patch

BuildRequires(pre): rpm-build-python3 unzip
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinxcontrib-qthelp
BuildRequires: python3-module-sphinxcontrib-htmlhelp
BuildRequires: python3-module-sphinxcontrib-jsmath
BuildRequires: python3-module-sphinxcontrib-devhelp
BuildRequires: python3-module-sphinxcontrib-applehelp
BuildRequires: python3-module-sphinxcontrib-aafig

%add_python3_req_skip py2exe ctypeslib

%description
Empty package

%package -n %packagename
Summary: Python wrapper for the chipmunk 2D physics engine
Group: Development/Python3
Requires: libchipmunk

%description -n %packagename
Pymunk is a Python wrapper for the wrapper for the chipmunk 2D physics
engine. It aims to be easy to use, "Pythonic", and non-intrusive.

%package examples
Summary: Example files for %name
Group: Development/Python3
BuildArch: noarch
Obsoletes: %name

%description examples
Example files for %packagename

%prep
%setup
%patch -p1

# XXX too old?
sed -i 's/def load_tests/def load_tests_xxx/' pymunk/tests/doctests.py

%build
export CFLAGS="-fPIC -O2 -g"
%python3_build_debug

make -C docs/src SPHINXBUILD=sphinx-build-3 BUILDDIR=../../build html

%install
%python3_install

%check
python3 setup.py test

%files examples
%doc examples

%files -n %packagename
%doc *txt build/html
%python3_sitelibdir/%name
%python3_sitelibdir/%name-*

%changelog
