%global modname etcd
%global srcname python-%{modname}
%global __ospython %{_bindir}/python3
%global python3_sitelib %(%{__ospython} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")

Name:           %{srcname}
Version:        0.4.5
Release:        alt1
Summary:        A python client library for etcd
Group:          System/Libraries
License:        MIT
URL:            http://pypi.python.org/pypi/%{srcname}
Source0:        %{name}-%{version}.tar

BuildArch:      noarch

# See https://bugzilla.redhat.com/1393497
# Also https://fedoraproject.org/wiki/Packaging:Guidelines#Noarch_with_Unported_Dependencies
ExclusiveArch:  noarch %{ix86} x86_64 %{arm} aarch64 ppc64le s390x

BuildRequires:  python3-dev
BuildRequires:  python3-module-setuptools
BuildRequires:  python3-module-dns
BuildRequires:  python3-module-mock
BuildRequires:  python3-module-nose
BuildRequires:  python3-module-urllib3
BuildRequires:  python3-module-OpenSSL

%description
Client library for interacting with an etcd service, providing Python
access to the full etcd REST API.  Includes authentication, accessing
and manipulating shared content, managing cluster members, and leader
election.

%package -n python3-module-%{modname}
Summary:        %summary
Group:          System/Libraries
Requires:       python3-module-dns
Requires:       python3-module-urllib3
Obsoletes:      python3-module-python-etcd
Provides:       python3-module-python-etcd
%{?python_provide:%python_provide python3-etcd}

%description -n python3-module-%{modname}
Client library for interacting with an etcd service, providing Python
access to the full etcd REST API.  Includes authentication, accessing
and manipulating shared content, managing cluster members, and leader
election.

%prep
%setup -n %name-%version

%build
%{__ospython} setup.py build

%install
%{__rm} -rf %{buildroot}
%{__ospython} setup.py install --root %{buildroot} -O1 --skip-build

%check
nosetests-3 src/etcd/tests/unit/

# This seems to require a newer python3-mock than what's currently available
# in F23, and even Rawhide.  If I let it download mock-1.3.0 from the Python
# Package Index (pypi) then tests pass.
#%%{__python3} setup.py test

%files -n python3-module-%{modname}
%doc README.rst
%doc LICENSE.txt
%{python3_sitelib}/*

%changelog
