%define _unpackaged_files_terminate_build 1
%define modname decorator
%def_enable python2

Name: python-module-%modname
Version: 4.4.2
Release: alt1

Summary: Better living through Python with decorators
License: BSD-style
Group: Development/Python
Url: http://pypi.python.org/pypi/decorator
Vcs: https://github.com/micheles/decorator.git

Source0: https://files.pythonhosted.org/packages/source/d/%modname/%modname-%version.tar.gz

BuildArch: noarch

%if_enabled python2
BuildRequires(pre): rpm-build-python
BuildRequires: python-devel
BuildRequires: python-module-setuptools
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools

%description
Python decorators are an interesting example of why syntactic sugar
matters. In principle, their introduction in Python changed nothing,
since they do not provide any new functionality which was not already
present in the language. In practice, their introduction has
significantly changed the way we structure our programs in Python. I
believe the change is for the best, and that decorators are a great idea
since:

* decorators help reducing boilerplate code;

* decorators help separation of concerns;

* decorators enhance readability and maintenability;

* decorators are explicit.

                     Michele Simionato <michele simionato at gmail com>

%package -n python3-module-%modname
Summary: Better living through Python 3 with decorators
Group: Development/Python3

%description -n python3-module-%modname
Python decorators are an interesting example of why syntactic sugar
matters. In principle, their introduction in Python changed nothing,
since they do not provide any new functionality which was not already
present in the language. In practice, their introduction has
significantly changed the way we structure our programs in Python. I
believe the change is for the best, and that decorators are a great idea
since:

* decorators help reducing boilerplate code;

* decorators help separation of concerns;

* decorators enhance readability and maintenability;

* decorators are explicit.

                     Michele Simionato <michele simionato at gmail com>

%prep
%setup -n %modname-%version %{?_enable_python2:-a0
mv %modname-%version py2build}

%build
%python3_build

%{?_enable_python2:
pushd py2build
%python_build
popd}

%install
%python3_install

%{?_enable_python2:
pushd py2build
%python_install
popd}

%if_enabled python2
%files
%python_sitelibdir/*
%doc CHANGES.md LICENSE.txt README.rst
%endif

%files -n python3-module-%modname
%python3_sitelibdir/*
%doc CHANGES.md LICENSE.txt README.rst

%changelog
