%define _unpackaged_files_terminate_build 1

%define oname mimeparse

Name: python-module-%oname
Version: 1.6.0
Release: alt4

Summary: Basic functions for handling mime-types in python
License: MIT
Group: Development/Python
BuildArch: noarch
Url: https://pypi.org/project/python-mimeparse

# https://github.com/dbtsai/python-mimeparse.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python
BuildRequires: python-devel python-module-setuptools
BuildRequires: python2.7(json)


%description
This module provides basic functions for handling mime-types. It can handle
matching mime-types against a list of media-ranges. See section 14.1 of 
the HTTP specification [RFC 2616] for a complete explanation.

   http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.1

Contents:
    - parse_mime_type():   Parses a mime-type into its component parts.
    - parse_media_range(): Media-ranges are mime-types with wild-cards
      and a 'q' quality parameter.
    - quality():           Determines the quality ('q') of a mime-type
      when compared against a list of media-ranges.
    - quality_parsed():    Just like quality() except the second
      parameter must be pre-parsed.
    - best_match():        Choose the mime-type with the highest quality
      ('q') from a list of candidates.

%prep
%setup

%build
%python_build_debug

%install
%python_install

%check
%__python mimeparse_test.py

%files
%doc README.rst LICENSE
%python_sitelibdir/*


%changelog
