%def_disable snapshot

%define _name pygobject
%define ver_major 3.36
%define api_ver 3.0
%define gtk_api_ver 3.0
%def_enable pycairo
%def_disable devel_doc
%def_disable tests
%def_enable check

Name: python-module-%{_name}3
Version: %ver_major.1
Release: alt4

Summary: Python bindings for GObject
Group: Development/Python
License: LGPL-2.1
Url: http://www.pygtk.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
Patch: pygobject-3.38.0-alt-meson-0.55_build.patch

%setup_python_module pygobject3

%add_findprov_lib_path %python_sitelibdir/gi

Requires: typelib(GdkX11) = %gtk_api_ver
%add_typelib_req_skiplist typelib(Foo)
%filter_from_requires /Gst.*/d
%filter_from_requires /typelib(WebKit)/d

%define glib_ver 2.48.0
%define gi_ver 1.46.0
%define pycairo_ver 1.11.1

BuildRequires(pre): meson rpm-build-gir rpm-build-python
BuildRequires: gtk-doc
BuildRequires: glib2-devel >= %glib_ver libgio-devel libffi-devel
BuildRequires: python-devel python-modules-encodings python-module-pytest
%{?_enable_pycairo:BuildRequires: python-module-pycairo-devel >= %pycairo_ver libcairo-gobject-devel}
BuildRequires: gobject-introspection-devel >= %gi_ver
%{?_enable_check:BuildRequires: xvfb-run dbus-tools-gui libgtk+3-gir-devel glibc-i18ndata}

%description
GObject is a object system used by GTK+, GStreamer and other libraries.

PyGObject provides a convenient wrapper for use in Python programs when
accessing GObject libraries.

PyGObject now dynamically accesses any GObject libraries that uses
GObject Introspection. It replaces the need for separate modules such as
PyGTK, GIO and python-gnome to build a full GNOME 3.0 application. Once
new functionality is added to gobject library it is instantly available
as a Python API without the need for intermediate Python glue.

%package pygtkcompat
Summary: PyGTK compatibility layer for PyGObject
Group: Development/Python
Requires: %name = %version-%release

%description pygtkcompat
PyGTK compatibility layer.
It is recommended to not depend on this layer, but only use it as an
intermediate step when porting your application to PyGI. Compatibility
might never be 100%%, but the aim is to make it possible to run a well
behaved PyGTK application mostly unmodified on top of PyGI.

%package devel
Summary: Development files for %name
Group: Development/Python
Requires: %name = %version-%release
Obsoletes: %name-common-devel < 3.37
Provides: %name-common-devel = %EVR
Conflicts: python3-module-pygobject3-devel > 3.37
%filter_from_provides /pkgconfig(pygobject-3.0)/d

%description devel
Development files for %name.


%prep
%setup -n %_name-%version
%patch -p1

%build
%meson \
	%{?_disable_pycairo:-Dpycairo=false} \
	%{?_disable_tests:-Dtests=false} \
	-Dpython=%__python
%nil
%meson_build

%install
%meson_install

%check
xvfb-run %meson_test

%files
%python_sitelibdir/gi/
%python_sitelibdir/*.egg-info
%exclude %python_sitelibdir/gi/pygtkcompat.py*

%files pygtkcompat
%python_sitelibdir/pygtkcompat/
%python_sitelibdir/gi/pygtkcompat.py*

%files devel
%_includedir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc

%changelog
