%define _unpackaged_files_terminate_build 1

%define oname testtools

Name: python-module-%oname
Version: 2.3.0
Release: alt4
Summary: extensions to the Python standard library's unit testing framework
Group: Development/Python
License: MIT
Url: http://pypi.python.org/pypi/testtools
BuildArch: noarch

# https://github.com/testing-cabal/testtools.git
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-alabaster python-module-docutils
BuildRequires: python-module-extras python-module-html5lib python-module-mimeparse
BuildRequires: python-module-objects.inv python-module-pbr python-module-pytest
BuildRequires: python-module-unittest2
BuildRequires: python2.7(testscenarios) python2.7(fixtures) python-module-twisted-core-test

%py_requires mimeparse traceback2

%description
testtools is a set of extensions to the Python standard library's unit
testing framework. These extensions have been derived from years of
experience with unit testing in Python and come from many different
sources.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
testtools is a set of extensions to the Python standard library's unit
testing framework. These extensions have been derived from years of
experience with unit testing in Python and come from many different
sources.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
testtools is a set of extensions to the Python standard library's unit
testing framework. These extensions have been derived from years of
experience with unit testing in Python and come from many different
sources.

This package contains documentation for %oname.

%prep
%setup

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
export PBR_VERSION=%version

%python_build

export PYTHONPATH=$PWD
%make -C doc pickle PYTHON=python2

%install
export PBR_VERSION=%version

%python_install

cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
export PBR_VERSION=%version

%make check PYTHON=python2

%files
%python_sitelibdir/testtools*
%doc LICENSE NEWS README*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle


%changelog
