%define _unpackaged_files_terminate_build 1
%define oname Fabric

%def_without check

Name: python3-module-%oname
Version: 2.5.1
Release: alt1

Summary: Simple, Pythonic remote execution and deployment.

License: BSD-2-Clause
Group: Development/Python3
Url: https://github.com/fabric/fabric

BuildArch: noarch

# Source-git: https://github.com/fabric/fabric.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro

# generated by 'epm restore --dry-run' from python3-module-Fabric-2.5.0/setup.py install_requires
%py3_use invoke < 2.0
%py3_use invoke >= 1.3
%py3_use paramiko >= 2.4

%if_with check
BuildRequires: python3-module-decorator
BuildRequires: python3-module-invoke
BuildRequires: python3-module-paramiko
BuildRequires: python3-module-six
BuildRequires: python3-module-yaml
%endif

Conflicts: python-module-%oname
%py3_provides %oname


%description
Fabric is a high level Python (2.7, 3.4+) library designed to execute shell
commands remotely over SSH, yielding useful Python objects in return. It builds
on top of Invoke (subprocess command execution and command-line features) and
Paramiko (SSH protocol implementation), extending their APIs to complement one
another and provide additional functionality.

%package tests
Summary: Tests for %oname.
Group: Development/Python3
Requires: python3-module-mock
%py3_requires %oname

%description tests
Fabric is a high level Python (2.7, 3.4+) library designed to execute shell
commands remotely over SSH, yielding useful Python objects in return. It builds
on top of Invoke (subprocess command execution and command-line features) and
Paramiko (SSH protocol implementation), extending their APIs to complement one
another and provide additional functionality.

This package contains tests for %oname.


%prep
%setup

%build
%python3_build

%install
%python3_install
%python3_prune

%check
%__python3 setup.py test

%files
%doc LICENSE README.rst
%_bindir/fab
%python3_sitelibdir/fabric/
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/fabric/testing

%files tests
%python3_sitelibdir/fabric/testing/

%changelog
