%define oname argcomplete

%def_without check

Name: python3-module-argcomplete
Version: 1.12.2
Release: alt1

Summary: Bash tab completion for argparse

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/argcomplete/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

Obsoletes: python-module-argcomplete
Provides: python-module-argcomplete

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-macros-sphinx
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-module-pexpect
BuildRequires: python3-module-tox
BuildRequires: /dev/pts
BuildRequires: tcsh
%endif

%description
Argcomplete provides easy, extensible command line tab completion of
arguments for your Python script.

It makes two assumptions:

* You're using bash or zsh as your shell
* You're using argparse to manage your command line arguments/options

%prep
%setup

%build
%python3_build

%install
%python3_install
%python3_prune

%if_with check
%check
export LC_ALL=C.UTF-8
export TOX_TESTENV_PASSENV='LC_ALL'
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v
%endif

%files
%doc *.rst
%_bindir/activate-global-python-argcomplete
%_bindir/python-argcomplete-check-easy-install-script
%_bindir/python-argcomplete-tcsh
%_bindir/register-python-argcomplete
%python3_sitelibdir/argcomplete/
%python3_sitelibdir/argcomplete-*.egg-info/

%changelog
