%define _unpackaged_files_terminate_build 1
%define pypi_name autopep8
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 2.1.1
Release: alt0.p10.1

Summary: A tool that automatically formats Python code to conform to the PEP 8 style guide
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/autopep8/
Vcs: https://github.com/hhatto/autopep8

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: setuptools-69.5.1-py3-none-any.whl
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
%add_findprov_skiplist %python3_sitelibdir/%mod_name/_vendor/*
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter pydiff
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: python3-module-pytest
%endif

%description
autopep8 automatically formats Python code to conform to the PEP 8
style guide. It uses the pycodestyle utility to determine what parts
of the code needs to be formatted. autopep8 is capable of fixing most
of the formatting issues that can be reported by pycodestyle.

%prep
%setup
%autopatch -p1

%build
# https://bugzilla.altlinux.org/47647
# build with bundled setuptools
mkdir dist
cp %SOURCE2 dist/
echo "$(basename '%SOURCE2')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDUNITTEST'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDUNITTEST

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc LICENSE README.rst AUTHORS.rst
%_bindir/%pypi_name
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
