Summary: An implementation the OpenBSD Blowfish password hashing algorithm
Version: 3.2.0
Release: alt2
Name: python3-module-bcrypt
Source0: %version.tar.gz
Source1: bfhash
Source2: bfhash.1
License: BSD
Group: Development/Python
Url: http://pypi.python.org/pypi/bcrypt

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python3-module-six python3-module-cffi

Conflicts: python-module-bcrypt < 3.1.7-alt4

%description
py-bcrypt is an implementation the OpenBSD Blowfish password hashing
algorithm, as described in "A Future-Adaptable Password Scheme" by Niels
Provos and David Mazieres: http://www.openbsd.org/papers/bcrypt-paper.ps

This system hashes passwords using a version of Bruce Schneier's
Blowfish block cipher with modifications designed to raise the cost of
off-line password cracking. The computation cost of the algorithm is
parametised, so it can be increased as computers get faster.

%prep
%setup -n bcrypt-%version

%build
%python3_build_debug

%install
%python3_install
install -D %SOURCE2  %buildroot%_man1dir/bfhash.1
install -D -m755 %SOURCE1 %buildroot%_bindir/bfhash

%files
%doc *.rst
%python3_sitelibdir/*
%_bindir/*
%_man1dir/*

%check
PYTHONPATH=%buildroot%python3_sitelibdir py.test3
test `PYTHONPATH=%buildroot%python3_sitelibdir %buildroot%_bindir/bfhash Password '$2a$08$saltsaltsaltsaltsaltsalt'` = '$2a$08$saltsaltsaltsaltsaltsOP5qmOWTOOR/q1xZLey.J4jBko3nSImS'

%changelog
