%define _unpackaged_files_terminate_build 1
%define oname behave

%def_with check

Name: python3-module-%oname
Version: 1.2.6
Release: alt4
Summary: behave is behaviour-driven development, Python style
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/behave/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/behave/behave.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(hamcrest)
BuildRequires: python3(mock)
BuildRequires: python3(nose)
BuildRequires: python3(parse)
BuildRequires: python3(parse_type)
BuildRequires: python3(path)
BuildRequires: python3(tox)
%endif

Requires: %oname-common = %EVR
%add_python3_req_skip gherkin
%add_python3_req_skip gherkin.formatter
%add_python3_req_skip gherkin.tag_expression

%description
Behavior-driven development (or BDD) is an agile software development
technique that encourages collaboration between developers, QA and
non-technical or business participants in a software project.

behave uses tests written in a natural language style, backed up by
Python code.

%package -n %oname-common
Summary: Common files for Python modules
Group: Development/Python3

%description -n %oname-common
Behavior-driven development (or BDD) is an agile software development
technique that encourages collaboration between developers, QA and
non-technical or business participants in a software project.

behave uses tests written in a natural language style, backed up by
Python code.

This package contains common files for Python 2 & 3 modules.

%prep
%setup
%patch -p1

%build
%python3_build

%install
%python3_install

pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd

install -d %buildroot%_sysconfdir
cp -fR etc/* %buildroot%_sysconfdir/

%check
sed -i -e '/\[testenv\]$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp {env:_PYTEST_BIN:} \{envbindir\}\/py.test\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/py.test' \
-e '/setenv =$/a \
    py%{python_version_nodots python3}: _PYTEST_BIN=%_bindir\/py.test3' \
-e '/behave --format=/d' \
tox.ini
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
%_bindir/tox.py3 --sitepackages -p auto -o -v

%files
%doc *.rst *features
%_bindir/behave.py3
%python3_sitelibdir/behave/
%python3_sitelibdir/setuptools_behave.py
%python3_sitelibdir/__pycache__/setuptools_behave.cpython-*.py*
%python3_sitelibdir/behave-%version-py%_python3_version.egg-info/

%files -n %oname-common
%dir %_sysconfdir/json
%_sysconfdir/json/behave.json-schema
%dir %_sysconfdir/junit.xml
%_sysconfdir/junit.xml/behave_junit.xsd
%_sysconfdir/junit.xml/junit-4.xsd

%changelog
