%define modname brotlipy

Name: python3-module-%modname
Version: 0.7.0
Release: alt3

Summary: Library contains Python bindings for the reference Brotli
License: MIT
Group: Development/Python3
Url: https://github.com/python-hyper/brotlipy/

Source: %modname-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: gcc-c++ python3-module-sphinx
BuildRequires: python3-module-cffi

%description
This library contains Python bindings for the reference Brotli 
encoder/decoder, available here. This allows Python software to 
use the Brotli compression algorithm directly from Python code.

%package docs
Summary: Documentation for %name
Group: Development/Documentation

%description docs
This library contains Python bindings for the reference Brotli 
encoder/decoder, available here. This allows Python software to 
use the Brotli compression algorithm directly from Python code.

This package contains documentation for %name

%prep
%setup -n %modname-%version

rm -rf *deb

%build
%python3_build_debug

export PYTHONPATH=$PWD
%make SPHINXBUILD="sphinx-build-3" -C docs man

%install
%python3_install

%check
python3 setup.py test

%files
%doc LICENSE *.rst
%python3_sitelibdir/*

%files docs
%doc docs/build/*

%changelog
