%define _unpackaged_files_terminate_build 1
%define pypi_name python-bugzilla
%define mod_name bugzilla

%def_with check

Name: python3-module-%mod_name
Version: 3.2.0
Release: alt1

Summary: Library and command line tool for interacting with Bugzilla
License: GPL-2.0
Group: Development/Python3
Url: https://pypi.org/project/python-bugzilla/

BuildArch: noarch

# Source-url: https://github.com/python-bugzilla/python-bugzilla
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# deps
BuildRequires: python3(requests)

BuildRequires: python3(pytest)
%endif

%py3_provides %pypi_name

%description
This package provides two bits:
- bugzilla python module for talking to a Bugzilla instance over XMLRPC or REST
- /usr/bin/bugzilla command line tool for performing actions from the command
line: create or edit bugs, various queries, etc.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc NEWS.md README.md examples
%_bindir/bugzilla
%_man1dir/bugzilla.*
%python3_sitelibdir/bugzilla/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
