%define _unpackaged_files_terminate_build 1
%define modulename cffi

%def_with check

Name: python3-module-cffi
Version: 1.14.5
Release: alt2

Summary: Foreign Function Interface for Python calling C code

Group: Development/Python3
License: MIT
Url: https://pypi.org/project/%modulename/

Source: https://files.pythonhosted.org/packages/93/1a/ab8c62b5838722f29f3daffcc8d4bd61844aa9b5f437341cc890ceee483b/%modulename-%version.tar.gz
Patch: cffi-0.8.6-alt-link.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libffi-devel

%if_with check
BuildRequires: gcc-c++
BuildRequires: python3(pycparser)
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
%endif

%py3_requires pycparser

%description
Foreign Function Interface for Python calling C code.

%prep
%setup -n %modulename-%version
%patch -p2

%build
%add_optflags -fno-strict-aliasing

%python3_build_debug

%install
%python3_install

%check
cat > tox.ini <<EOF
[testenv]
commands = {envpython} -m pytest {posargs:.}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%python3_sitelibdir/_cffi_backend.cpython-%{python_version_nodots python3}.so
%python3_sitelibdir/%modulename/
%python3_sitelibdir/%modulename-%version-py%_python3_version.egg-info/

%changelog
