%define _unpackaged_files_terminate_build 1
%define pypi_name click

%def_with check

Name: python3-module-%pypi_name
Version: 8.1.3
Release: alt1

Summary: Composable command line interface toolkit

License: BSD
Group: Development/Python
Url: https://pypi.org/project/click/

# Source-git: https://github.com/pallets/click.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildArch: noarch
BuildRequires: rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
%endif

%description
Click is a Python package for creating beautiful command line interfaces
in a composable way with as little code as necessary.  It's the "Command
Line Interface Creation Kit".  It's highly configurable but comes with
sensible defaults out of the box.

It aims to make the process of writing command line tools quick and fun
while also preventing any frustration caused by the inability to
implement an intended CLI API.

%prep
%setup
%autopatch -p1
rm src/click/_winconsole.py

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc README.* LICENSE.rst
%python3_sitelibdir/click/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
