%define oname cx-freeze

Name: python3-module-%oname
Version: 6.1
Release: alt1

Summary: Scripts and modules for freezing Python scripts into executables
License: PSF
Group: Development/Python3
URL: http://cx-freeze.sourceforge.net/

Source: %oname-%version.tar.bz2

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx chrpath

Conflicts: python-module-%oname
Provides: cx_Freeze

%add_python3_req_skip BUILD_CONSTANTS


%description
cx_Freeze is a set of scripts and modules for freezing Python scripts into
executables in much the same way that py2exe and py2app do. It requires Python
2.3 or higher since it makes use of the zip import facility which was introduced
in that version.

There are three different ways to use cx_Freeze. The first is to use the
included freeze script which works well for simple scripts. The second is to
create a distutils setup script which can be used for more complicated
configuration or to retain the configuration for future use. The third method
involves working directly with the classes and modules used internally by
cx_Freeze and should be reserved for complicated scripts or extending or
embedding.

There are three different options for producing executables as well. The first
option is the only one that was available in earlier versions of cx_Freeze, that
is appending the zip file to the executable itself. The second option is
creating a private zip file with the same name as the executable but with the
extension .zip. The final option is the default which is to create a zip file
called library.zip and place all modules in this zip file. The final two options
are necessary when creating an RPM since the RPM builder automatically strips
executables.

%package samples
Summary: Samples for cx_Freeze
Group: Development/Documentation
BuildArch: noarch

%description samples
cx_Freeze is a set of scripts and modules for freezing Python scripts into
executables in much the same way that py2exe and py2app do. It requires Python
2.3 or higher since it makes use of the zip import facility which was introduced
in that version.

This package contains samples for cx_Freeze.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

%build
%python3_build_debug

%make -C doc html

%install
%python3_install

rm -f $(find %buildroot -name 'windist*')

for i in $(find %buildroot%python3_sitelibdir/cx_Freeze/ -type d)
do
    touch $i/__init__.py
done

for i in %buildroot%python3_sitelibdir/cx_Freeze/bases/Console*
do
    chrpath -d $i
done

%files
%doc README.md doc/build/html/*
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/samples

%files samples
%doc cx_Freeze/samples


%changelog
