%define oname doubles

%def_disable check

Name: python3-module-%oname
Version: 1.0.5
Release: alt2

Summary: Test doubles for Python
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/doubles/

BuildArch: noarch

# https://github.com/uber/doubles.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-pytest


%description
Doubles is a Python package that provides test doubles for use in
automated tests.

It provides functionality for stubbing, mocking, and verification of
test doubles against the real objects they double. In contrast to the
Mock package, it provides a clear, expressive syntax and better safety
guarantees to prevent API drift and to improve confidence in tests using
doubles. It comes with drop-in support for test suites run by Pytest,
Nose, or standard unittest.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
Doubles is a Python package that provides test doubles for use in
automated tests.

It provides functionality for stubbing, mocking, and verification of
test doubles against the real objects they double. In contrast to the
Mock package, it provides a clear, expressive syntax and better safety
guarantees to prevent API drift and to improve confidence in tests using
doubles. It comes with drop-in support for test suites run by Pytest,
Nose, or standard unittest.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Doubles is a Python package that provides test doubles for use in
automated tests.

It provides functionality for stubbing, mocking, and verification of
test doubles against the real objects they double. In contrast to the
Mock package, it provides a clear, expressive syntax and better safety
guarantees to prevent API drift and to improve confidence in tests using
doubles. It comes with drop-in support for test suites run by Pytest,
Nose, or standard unittest.

This package contains documentation for %oname.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

%build
%python3_build_debug

%install
%python3_install

export PYTHONPATH=$PWD
%make -C docs pickle
%make -C docs html

cp -fR docs/build/pickle %buildroot%python3_sitelibdir/%oname/

%check
%__python3 setup.py test

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*


%changelog
