%define _unpackaged_files_terminate_build 1

%define oname freezegun
%def_with check

Name: python3-module-%oname
Version: 1.1.0
Release: alt1
Summary: Let your Python tests travel through time
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/freezegun/

# https://github.com/spulec/freezegun.git
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(dateutil)
BuildRequires: python3(mock)
BuildRequires: python3(pytest)
BuildRequires: python3(sqlite3)
%endif

%description
FreezeGun is a library that allows your python tests to travel through
time by mocking the datetime module.

%prep
%setup
# unnecessary requirements
sed -i -e '/.*cover.*/d' \
       -e '/maya/d' \
       -e 's/pytest==.*/pytest/' \
       requirements.txt

%build
%python3_build

%install
%python3_install
# not used in Python3.6+, causes problems
rm %buildroot%python3_sitelibdir/%oname/_async_coroutine.py

%check
py.test3 -vra

%files
%doc *.rst
%python3_sitelibdir/freezegun/
%python3_sitelibdir/freezegun-*.egg-info/

%changelog
