%define oname gdata

Name: python3-module-gdata
Version: 2.0.18
Release: alt4

Summary: A Python module for accessing online Google services
Group: Development/Python3
License: Apache-2.0
Url: https://github.com/google/gdata-python-client
BuildArch: noarch

# Source0-git:	https://github.com/google/gdata-python-client.git
Source: %name-%version-%release.tar
Patch0: port-on-python3.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python-tools-2to3

%add_python3_req_skip google.appengine.api google.appengine.ext


%description
This is a Python module for accessing online Google services, such as:
- Blogger
- Calendar
- Picasa Web Albums
- Spreadsheets
- YouTube
- Notebook
and other

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
This is a Python module for accessing online Google services, such as:
- Blogger
- Calendar
- Picasa Web Albums
- Spreadsheets
- YouTube
- Notebook
and other

This package contains documentation for %oname.

%prep
%setup
%patch0 -p1

rm -f samples/apps/emailsettings_pop_settings.py
find ./ -type f -name '*.py' -exec 2to3 -w -n '{}' +

%build
%python3_build

chmod -x samples/*/*.py

rm -rf src/gdata/Crypto/test.py
rm -rf src/gdata/Crypto/Util/test.py

%install
%python3_install

chmod -x samples/*/*.py

rm -rf src/gdata/Crypto/test.py
rm -rf src/gdata/Crypto/Util/test.py

install -d %buildroot%python3_sitelibdir/%oname/finance
install -d %buildroot%python3_sitelibdir/%oname/finance/__pycache__

for i in $(find src/%oname/finance -name '*.py')
do
    install -p -m644 $i %buildroot%python3_sitelibdir/%oname/finance/
done
for i in $(find src/%oname/finance/__pycache__ -name '*.pyc')
do
    install -p -m644 $i %buildroot%python3_sitelibdir/%oname/finance/__pycahce__
done

%files
%doc *.txt
%python3_sitelibdir/atom/
%python3_sitelibdir/gdata/
%python3_sitelibdir/*.egg-info

%files docs
%doc pydocs/*


%changelog
