%define _unpackaged_files_terminate_build 1
%define oname hiredis

%def_with check

Name: python3-module-%oname
Version: 2.0.0
Release: alt1

Summary: Python wrapper for hiredis

License: BSD
Group: Development/Python3
Url: https://github.com/redis/hiredis-py

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libhiredis-devel

%if_with check
BuildRequires: python3(tox)
%endif

%description
Python wrapper for hiredis.

%prep
%setup
%autopatch -p1

# use the system's one
rm -r ./vendor/hiredis/

%build
%python3_build

%install
%python3_install

%check
cat > tox.ini <<EOF
[testenv]
usedevelop=True
commands =
    {envpython} test.py
EOF
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%python3_sitelibdir/%oname/
%python3_sitelibdir/*.egg-*

%changelog
