%define oname html5lib

%def_without doc

Name: python3-module-html5lib
Epoch: 1
Version: 1.1
Release: alt1

Summary: Library for working with HTML5 documents

License: MIT
Group: Development/Python3
Url: https://github.com/html5lib/html5lib-python

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3

BuildArch: noarch

%{?_with_doc:BuildRequires(pre): rpm-macros-sphinx3}

#BuildRequires: python3-dev
BuildRequires: python3-module-setuptools >= 18.5
BuildRequires: python3(webencodings)
BuildRequires: python3(pytest) python3(six) python3(mock)

%description
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

%package doc
Summary: Documentation for html5lib
Group: Development/Documentation

%description doc
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

This package contains documentation for html5lib.

%prep
%setup
rm -f html5lib/tests/conftest.py
# https://github.com/html5lib/html5lib-python/issues/433
rm -f html5lib/tests/test_encoding.py
#sed -i "s|import chardet|raise ImportError('Skipping chardet test: file is missing')|g" html5lib/tests/test_encoding.py

%if_with doc
%prepare_sphinx3 .
ln -s ../objects.inv doc/
%endif

%build
%python3_build

%if_with doc
%make -C doc html
%endif

%install
%python3_install
%python3_prune

%check
py.test3

%files
%doc README.rst
%python3_sitelibdir/*

%if_with doc

%files doc
%doc doc/_build/html/*
%endif

%changelog
