%define _unpackaged_files_terminate_build 1
%define pypi_name importlib-metadata

%def_with check

Name: python3-module-%pypi_name
Version: 5.1.0
Release: alt1
Summary: Library to access the metadata for a Python package
License: Apache-2.0
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.org/project/importlib-metadata/
VCS: https://github.com/python/importlib_metadata.git

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(setuptools_scm)

%if_with check
# install_requires:
BuildRequires: python3(zipp)

BuildRequires: python3(pyfakefs)
BuildRequires: python3(test)
%endif

# PyPI name(dash, underscore)
%py3_provides %pypi_name
Provides: python3-module-importlib_metadata = %EVR
Obsoletes: python3-module-importlib_metadata <= 1.5.0-alt1

%description
Library to access the metadata for a Python package.

This package supplies third-party access to the functionality of
importlib.metadata including improvements added to subsequent Python versions.

New features are introduced in this third-party library and later merged into
CPython.

%prep
%setup
%patch -p1
# setuptools_scm implements a file_finders entry point which returns all files
# tracked by SCM.
if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag '%version'
fi

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject -- \
    --ignore exercises.py

%files
%doc README.rst
%python3_sitelibdir/importlib_metadata/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
