%define _unpackaged_files_terminate_build 1
%define pypi_name jaraco.text

%def_with check

%define add_python_extra() \
%{expand:%%package -n %%name+%1 \
Summary: %%summary \
Group: Development/Python3 \
Requires: %%name \
%{expand:%%pyproject_runtimedeps_metadata -- --extra %1} \
%%description -n %%name+%1' \
Extra "%1" for %%pypi_name. \
%%files -n %%name+%1 \
}

Name: python3-module-%pypi_name
Version: 4.0.0
Release: alt0.p10.1
Summary: Module for text manipulation
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/jaraco.text/
VCS: https://github.com/jaraco/jaraco.text
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: setuptools-68.2.2-py3-none-any.whl
Patch0: %name-%version-%release.patch
# manually manage extra dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR

BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata_extra test
%pyproject_builddeps_metadata_extra inflect
%endif

%description
%summary

%add_python_extra inflect

%prep
%setup
%patch0 -p1
%pyproject_scm_init
%pyproject_deps_resync_build
# https://bugzilla.altlinux.org/47647
# build with bundled setuptools
mkdir dist
cp %SOURCE2 dist/
echo "$(basename '%SOURCE2')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDRUN'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_deps_resync_metadata
%define __python3 %__python3_orig
ENDRUN

%build
%pyproject_run -- bash -s <<-'ENDRUN'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDRUN

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%python3_sitelibdir/jaraco/*
%python3_sitelibdir/jaraco.text-%version.dist-info/

%changelog
