%define _unpackaged_files_terminate_build 1

%define mname kdcproxy
%def_with check

Name: python3-module-%mname
Version: 1.0.0
Release: alt1

Summary: A kerberos KDC HTTP proxy WSGI module
License: %mit
Group: Development/Python3
Url: https://pypi.org/project/kdcproxy
# Source-git: https://github.com/latchset/kdcproxy

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: libkrb5
BuildRequires: python3(dns)
BuildRequires: python3(pyasn1)
BuildRequires: python3(tox)
BuildRequires: python3(webtest)
%endif

BuildArch: noarch

%description
This package contains a Python 3.x WSGI module for proxying KDC requests
over HTTP by following the MS-KKDCP protocol. It aims to be simple
to deploy, with minimal configuration.

%prep
%setup
%patch -p1

%build
%python3_build

%install
%python3_install

%check
export PIP_NO_INDEX=YES
export TOXENV=py3
%_bindir/tox.py3 --sitepackages -vvr

%files
%doc COPYING README
%python3_sitelibdir/%mname/
%python3_sitelibdir/%mname-%version-py%_python3_version.egg-info/

%changelog
