%define oname latexcodec

Name: python3-module-%oname
Version: 2.0.1
Release: alt1

Summary: A lexer and codec to work with LaTeX code in Python
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/latexcodec
BuildArch: noarch

# https://github.com/mcmtroffaes/latexcodec.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-coverage python3-module-nose
BuildRequires: python3-module-sphinx python3-module-six
BuildRequires: python3-module-pytest

%py3_provides %oname
%py3_requires six


%description
A lexer and codec to work with LaTeX code in Python.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
A lexer and codec to work with LaTeX code in Python.

This package contains pickles for %oname.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

%build
%python3_build

%install
%python3_install

export PYTHONPATH=$PWD
%make -C doc pickle
%make -C doc html
cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
%__python3 setup.py test -v
export PYTHONPATH=$PWD
coverage3 run --source=latexcodec $(type -p nosetests3) -vv

%files
%doc *.rst doc/_build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle


%changelog
