%define _unpackaged_files_terminate_build 1
%define oname lazy-object-proxy

%def_with check

Name: python3-module-%oname
Version: 1.6.0
Release: alt3

Summary: A fast and thorough lazy object proxy
License: BSD
Group: Development/Python3
# Source-git: https://github.com/ionelmc/python-lazy-object-proxy.git
Url: https://pypi.org/project/lazy-object-proxy/

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools_scm)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(pytest_benchmark)
BuildRequires: python3(pytest_cov)
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox_console_scripts)
%endif

%py3_provides lazy-object-proxy

Provides: python3-module-lazy_object_proxy = %EVR
Obsoletes: python3-module-lazy_object_proxy < %EVR

%description
This Python module is based on wrapt's ObjectProxy with one big change: it
calls a function the first time the proxy object is used, while
wrapt.ObjectProxy just forwards the method calls to the target object.

%prep
%setup
%autopatch -p1

%build
%add_optflags -fno-strict-aliasing
%python3_build

%install
%python3_install

%check
export PIP_NO_INDEX=YES
export PIP_NO_BUILD_ISOLATION=no
export TOXENV=py%{python_version_nodots python3}-cover
tox.py3 --sitepackages -vvr --no-deps --console-scripts -s false

%files
%doc AUTHORS.rst README.rst CHANGELOG.rst
%dir %python3_sitelibdir/lazy_object_proxy
%python3_sitelibdir/lazy_object_proxy/*.py
%python3_sitelibdir/lazy_object_proxy/__pycache__/
%python3_sitelibdir/lazy_object_proxy/cext.cpython-*.so
%python3_sitelibdir/lazy_object_proxy-%version-py%_python3_version.egg-info/

%changelog
