%define oname logilab-astng

%def_disable check

Name: python3-module-%oname
Version: 0.24.2
Release: alt2

Summary: Python Abstract Syntax Tree New Generation
License: LGPLv2.1+
Group: Development/Python3
Url: http://www.logilab.org/project/logilab-astng
BuildArch: noarch

# hg clone http://hg.logilab.org/logilab/astng
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python-tools-2to3 python3-module-logilab-common

%{?!_without_check:%{?!_disable_check:BuildRequires: /usr/bin/pytest}}


%description
The aim of this module is to provide a common base representation of
python source code for projects such as pychecker, pyreverse, pylint...
Well, actually the development of this library is essentialy governed by
pylint's needs.
It extends class defined in the compiler.ast [1] module (python <= 2.4)
or in the builtin _ast module (python >= 2.5) with some additional
methods and attributes. Instance attributes are added by a builder
object, which can either generate extended ast (let's call them astng ;)
by visiting an existant ast tree or by inspecting living object. Methods
are added by monkey patching ast classes.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build

%install
%python3_install

rm -rf %buildroot%python3_sitelibdir/logilab/astng/test
rm -rf %buildroot%python3_sitelibdir/logilab/__init__.py*

%check
touch build/lib/logilab/__init__.py
ln -sf %python3_sitelibdir/logilab/common build/lib/logilab/common
PYTHONPATH=$(pwd)/build/lib/ pytest3 -t test
rm -f build/lib/logilab/{common,__init__.py}

%files
%doc ChangeLog README
%python3_sitelibdir/logilab/
%python3_sitelibdir/*.egg-info


%changelog
