%define _unpackaged_files_terminate_build 1
%define oname logilab-common

%def_enable check

Name: python3-module-%oname
Version: 1.5.2
Release: alt1

Summary: Useful miscellaneous modules used by Logilab projects
License: LGPLv2.1+
Group: Development/Python3
Url: http://www.logilab.org/project/logilab-common

BuildArch: noarch

# hg clone http://hg.logilab.org/review/logilab/common/
Source: %oname-%version.tar
Patch0: port-to-new-python.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytz

%py3_provides logilab

%description
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging

%prep
%setup -q -n %oname-%version
%patch0 -p2

%build
%python3_build

%install
%python3_install

# man file
install -pD -m644 docs/logilab-pytest.1 -T \
    %buildroot%_man1dir/logilab-pytest-3.1
# rename binary
mv %buildroot%_bindir/logilab-pytest -T \
    %buildroot%_bindir/logilab-pytest-3

%check
PYTHONPATH=%buildroot%python3_sitelibdir \
    %buildroot%_bindir/logilab-pytest-3 \
    -t test \
    -s test_4

%files
%doc ChangeLog README COPYING
%_man1dir/logilab-pytest-3.1*
%_bindir/logilab-pytest-3
%python3_sitelibdir/logilab/common/*.py
%python3_sitelibdir/logilab/common/__pycache__/
%python3_sitelibdir/logilab/common/ureports/*.py
%python3_sitelibdir/logilab/common/ureports/__pycache__/
%python3_sitelibdir/*.egg-info/
%exclude %python3_sitelibdir/*-nspkg.pth

%changelog
