%define oname mdp

Name: python3-module-%oname
Version: 3.5
Release: alt2

Summary: Modular toolkit for Data Processing

Group: Development/Python3
License: LGPL v2
URL: http://mdp-toolkit.sourceforge.net/

# git://github.com/mdp-toolkit/mdp-toolkit
Source: %oname-%version.tar.gz
Source1: MDP-tutorial.pdf

BuildArch: noarch

%add_python3_req_skip test shogun UserDict

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-scipy libnumpy-py3-devel


%description
Modular toolkit for Data Processing (MDP) is a Python data processing
framework.

From the user's perspective, MDP is a collection of supervised and
unsupervised learning algorithms and other data processing units that
can be combined into data processing sequences and more complex
feed-forward network architectures.

From the scientific developer's perspective, MDP is a modular framework,
which can easily be expanded. The implementation of new algorithms is
easy and intuitive. The new implemented units are then automatically
integrated with the rest of the library.

The base of available algorithms is steadily increasing and includes, to
name but the most common, Principal Component Analysis (PCA and NIPALS),
several Independent Component Analysis algorithms (CuBICA, FastICA,
TDSEP, JADE, and XSFA), Slow Feature Analysis, Gaussian Classifiers,
Restricted Boltzmann Machine, and Locally Linear Embedding.

%package tests
Summary: Tests for Modular toolkit for Data Processing
Group: Development/Python3
Requires: %name = %version-%release

%description tests
Modular toolkit for Data Processing (MDP) is a Python data processing
framework.

This package contains tests for MDP.

%package doc
Summary: Documentation for Modular toolkit for Data Processing
Group: Development/Documentation
BuildArch: noarch

%description doc
Modular toolkit for Data Processing (MDP) is a Python data processing
framework.

This package contains documentation for MDP.

%prep
%setup
install -p -m644 %SOURCE1 .

sed -i 's|#! /usr/bin/env python|#! /usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build

%install
%python3_install

%files
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/test
%exclude %python3_sitelibdir/bimdp/test

%files tests
%python3_sitelibdir/%oname/test
%python3_sitelibdir/bimdp/test

%files doc
%doc *.pdf CHANGES CHECKLIST COPYRIGHT
%doc README TODO


%changelog
