%define _unpackaged_files_terminate_build 1
%define oname moto

%def_without check
# full testsuite takes too long for now, run it locally
# name                      aarch64   armh   i586  ppc64le  x86_64
# python3-module-moto         20:32  35:22  12:18    25:10   12:09
%def_without full_testsuite

Name: python3-module-%oname
Version: 3.0.7
Release: alt0.p10.1

Summary: A library that allows your python tests to easily mock out the boto library
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/moto/

BuildArch: noarch

# https://github.com/spulec/moto.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
# install_requires=
BuildRequires: python3(boto3)
BuildRequires: python3(botocore)
BuildRequires: python3(cryptography)
BuildRequires: python3(requests)
BuildRequires: python3(xmltodict)
BuildRequires: python3(werkzeug)
BuildRequires: python3(pytz)
BuildRequires: python3(dateutil)
BuildRequires: python3(responses)
BuildRequires: python3(jinja2)

BuildRequires: python3(sure)
BuildRequires: python3(freezegun)
BuildRequires: python3(flask)
BuildRequires: python3(flask_cors)
BuildRequires: python3(jose)
BuildRequires: python3(aws_xray_sdk)
BuildRequires: python3(yaml)
BuildRequires: python3(jsondiff)
BuildRequires: python3(docker)

BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
%endif

# not detected external dep
%py3_requires responses

%description
Moto is a library that allows your python tests to easily mock out the
boto library.

%prep
%setup
%autopatch -p1

%build
%python3_build

%install
%python3_install

%check
cat > tox.ini <<'EOF'
[testenv]
commands =
    pytest {posargs:-vra}
EOF
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export NO_INTERNET=YES
export NO_DOCKERD=YES
export TOXENV=py3
export TOX_TESTENV_PASSENV='NO_INTERNET NO_DOCKERD'
%if_with full_testsuite
export TESTS=tests
%else
export TESTS=tests/test_core
%endif
# test_batch_jobs requires internet
tox.py3 --sitepackages --console-scripts -vvr -s false --develop -- \
    -vra $TESTS \
    -m 'not network' \
    --ignore tests/test_batch/test_batch_jobs.py

%files
%doc LICENSE
%doc *.md
%_bindir/moto_server
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py*.egg-info

%changelog
