Name: python3-module-mutagen
Version: 1.45.1
Release: alt1

Summary: Python module to handle audio metadata
License: GPLv2
Group: Development/Python
Url: https://github.com/quodlibet/mutagen.git

Source0: %name-%version.tar

BuildArch: noarch
BuildRequires: rpm-build-python3 python3-module-setuptools
BuildRequires: python3(pytest) python3(hypothesis)

%description
Mutagen is a Python module to handle audio metadata. It supports FLAC,
M4A, Musepack, MP3, Ogg FLAC, Ogg Speex, Ogg Theora, Ogg Vorbis, True
Audio, and WavPack audio files. All versions of ID3v2 are supported, and
all standard ID3v2.4 frames are parsed. It can read Xing headers to
accurately calculate the bitrate and length of MP3s. ID3 and APEv2 tags
can be edited regardless of audio format. It can also manipulate Ogg
streams on an individual packet/page level.

%package -n mutagen
Summary: Various mutagen (python module to handle audio metadata) binary tools
Group: Sound
Requires: python3-module-mutagen = %version-%release

%description -n mutagen
%summary

%prep
%setup
rm tests/quality/test_*.py

%build
%python3_build

%install
%python3_install

%check
LC_ALL=en_US.UTF-8 \
python3 setup.py test

%files
%doc COPYING NEWS README.rst
%python3_sitelibdir/*

%files -n mutagen
%_bindir/*
%_man1dir/*

%changelog
