%define oname netCDF4

%def_disable check

Name: python3-module-%oname
Version: 1.5.6
Release: alt2
Summary: Python/numpy interface to netCDF library (versions 3 and 4)
License: BSD / MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/netCDF4/

# https://github.com/Unidata/netcdf4-python.git
Source: %name-%version.tar
Source1: setup.cfg

BuildRequires: libnetcdf-devel zlib-devel libjpeg-devel libcurl-devel
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-Cython libnumpy-py3-devel
BuildRequires: python3-module-html5lib
BuildRequires: python3-module-notebook python3-module-numpy-testing
BuildRequires: libhdf5-devel

Conflicts: python-module-%oname
Obsoletes: python-module-%oname

%py3_provides %oname

%description
netCDF version 4 has many features not found in earlier versions of the
library and is implemented on top of HDF5. This module can read and
write files in both the new netCDF 4 and the old netCDF 3 format, and
can create files that are readable by HDF5 clients. The API modelled
after Scientific.IO.NetCDF, and should be familiar to users of that
module.

Most new features of netCDF 4 are implemented, such as multiple
unlimited dimensions, groups and zlib data compression. All the new
numeric data types (such as 64 bit and unsigned integer types) are
implemented. Compound and variable length (vlen) data types are
supported, but the enum and opaque data types are not. Mixtures of
compound and vlen data types (compound types containing vlens, and vlens
containing compound types) are not supported.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
netCDF version 4 has many features not found in earlier versions of the
library and is implemented on top of HDF5. This module can read and
write files in both the new netCDF 4 and the old netCDF 3 format, and
can create files that are readable by HDF5 clients. The API modelled
after Scientific.IO.NetCDF, and should be familiar to users of that
module.

Most new features of netCDF 4 are implemented, such as multiple
unlimited dimensions, groups and zlib data compression. All the new
numeric data types (such as 64 bit and unsigned integer types) are
implemented. Compound and variable length (vlen) data types are
supported, but the enum and opaque data types are not. Mixtures of
compound and vlen data types (compound types containing vlens, and vlens
containing compound types) are not supported.

This package contains documentation for %oname.

%prep
%setup

install -m644 %SOURCE1 ./
rm -f *.c netCDF4.c netcdftime/.c

sed -i "s|'lib'|'%_lib'|g" setup.py

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

#export PYTHONPATH=%buildroot%python3_sitelibdir
#chmod +x create_docs.sh
#cd docs
#../create_docs.sh

%check
python3 setup.py test
pushd test
export PYTHONPATH=%buildroot%python3_sitelibdir
python3 run_all.py
popd

%files
%doc Changelog *.md
%_bindir/*
%python3_sitelibdir/*

%files docs
#doc docs/html examples

%changelog
