%define _unpackaged_files_terminate_build 1

%define oname networkx

Name:           python3-module-%oname
Epoch:          2
Version:        2.5.1
Release:        alt2
Summary:        Creates and Manipulates Graphs and Networks
Group:          Development/Python3
License:        BSD-3-Clause
URL:            http://networkx.github.io

BuildArch:      noarch

# https://github.com/networkx/networkx.git
Source:         %name-%version.tar

Patch1:         %oname-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-decorator >= 4.3.0
#BuildRequires: python3-module-numpy >= 1.15.0
#BuildRequires: python3-module-scipy >= 1.1.0
#BuildRequires: python3-module-pandas >= 0.23.3
#BuildRequires: python3-module-matplotlib >= 2.2.2
#BuildRequires: python3-module-pygraphviz >= 1.5
#BuildRequires: python3-module-pydot >= 1.2.4
BuildRequires: python3-module-yaml >= 5.3
BuildRequires: python3-module-lxml >= 4.5
BuildRequires: python3-module-gdal >= 1.10.0

Requires: %name-drawing = %EVR

%description
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package core
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: python3-module-decorator
Requires: python3-module-yaml
#Requires: python3-module-numpy
#Requires: python3-module-scipy
%add_python3_req_skip tests
%add_python3_req_skip networkx.tests.test

%description core
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package drawing
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: %name-core = %EVR
Requires: python3-module-pygraphviz >= 1.5
Requires: python3-module-pygraphviz < 2.0
Requires: python3-module-pydot >= 1.4.1
Requires: python3-module-matplotlib >= 3.2

%description drawing
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package provides support for graph visualizations.

%package tests
Summary: Tests for NetworkX (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description tests
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package contains tests for NetworkX.

%prep
%setup
%patch1 -p1

find -type f -name '*.py' -exec sed -i \
	's|#!/usr/bin/env python|#!/usr/bin/env python3|' '{}' +

%build
%python3_build

%install
%python3_install

rm -rf %buildroot%_defaultdocdir

%files

%files core
%doc LICENSE.txt
%doc README.rst CODE_OF_CONDUCT.rst CONTRIBUTING.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py*.egg-info
%exclude %python3_sitelibdir/%oname/drawing
%exclude %python3_sitelibdir/%oname/readwrite/nx_shp.py
%exclude %python3_sitelibdir/%oname/readwrite/__pycache__/nx_shp.*
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/conftest.py
%exclude %python3_sitelibdir/%oname/testing
%exclude %python3_sitelibdir/%oname/*/tests
%exclude %python3_sitelibdir/%oname/*/*/tests

%files drawing
%python3_sitelibdir/%oname/drawing
%python3_sitelibdir/%oname/readwrite/nx_shp.py
%python3_sitelibdir/%oname/readwrite/__pycache__/nx_shp.*
%exclude %python3_sitelibdir/%oname/drawing/tests

%files tests
%python3_sitelibdir/%oname/conftest.py
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/testing
%python3_sitelibdir/%oname/*/tests
%python3_sitelibdir/%oname/*/*/tests

%changelog
