%define  oname numba

Name:    python3-module-%oname
Version: 0.53.1
Release: alt1

Summary: A Just-In-Time Compiler for Numerical Functions in Python

License: BSD
Group:   Development/Python3
URL:     https://pypi.org/project/numba

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3 python3-module-six
BuildRequires: gcc-c++ libgomp-devel libnumpy-py3-devel

Source:  %oname-%version.tar

%description
Numba is an open source, NumPy-aware optimizing compiler for Python sponsored by
Anaconda, Inc. It uses the LLVM compiler project to generate machine code from
Python syntax.

Numba can compile a large subset of numerically-focused Python, including many
NumPy functions. Additionally, Numba has support for automatic parallelization
of loops, generation of GPU-accelerated code, and creation of ufuncs and
C callbacks.

%prep
%setup -n %oname-%version

%build
%python3_build

%install
%python3_install

mv %buildroot%_bindir/numba %buildroot%_bindir/numba3
mv %buildroot%_bindir/pycc %buildroot%_bindir/pycc3

%files
%_bindir/numba3
%_bindir/pycc3
%python3_sitelibdir/%oname/
%python3_sitelibdir/*.egg-info
%doc CHANGE_LOG *.rst

%changelog
