%define oname oslo.cache
%def_without check
%def_with docs

Name: python3-module-%oname
Version: 3.3.0
Release: alt1.1.p10

Summary: Cache storage for OpenStack projects

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.cache

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-cache = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-dogpile.cache >= 1.1.5
BuildRequires: python3-module-oslo.config >= 8.1.0
BuildRequires: python3-module-oslo.i18n >= 5.0.0
BuildRequires: python3-module-oslo.log >= 4.2.1
BuildRequires: python3-module-oslo.utils >= 4.2.0
BuildRequires: python3-module-typing-extensions
BuildRequires: python3-module-binary-memcached

%if_with check
BuildRequires: python3-module-memcached >= 1.56
BuildRequires: python3-module-pymongo >= 3.0.2
BuildRequires: python3-module-etcd3gw >= 0.2.0
BuildRequires: python3-module-hacking >= 3.0.1
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-pifpaf >= 0.10.0
BuildRequires: python3-module-bandit >= 1.6.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-pymemcache >= 3.5.0
BuildRequires: python3-module-binary-memcached
BuildRequires: python3-module-pre-commit >= 2.6.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme
BuildRequires: python3-module-sphinxcontrib-apidoc
%endif

%py3_requires dogpile.cache

Requires: python3-module-dogpile.cache >= 1.1.5
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-binary-memcached

%description
oslo.cache aims to provide a generic caching mechanism for OpenStack projects
by wrapping the dogpile.cache library. The dogpile.cache library provides
support memoization, key value storage and interfaces to common caching backends
such as Memcached.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-cache-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/oslocache.1 %buildroot%_man1dir/oslocache.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/oslo_cache
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/oslo_cache/tests

%files tests
%python3_sitelibdir/oslo_cache/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/oslocache.1.xz
%endif

%changelog
