%define oname oslo.log
%def_without check
%def_with docs

Name: python3-module-%oname
Version: 5.2.0
Release: alt0.p10

Summary: OpenStack Oslo Log library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.log

Source: %oname-%version.tar
Source1: %oname.watch

Patch1: oslo.log-ustream-catch-runtime-error.patch

BuildArch: noarch

Provides: python3-module-oslo-log = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 3.1.1
BuildRequires: python3-module-oslo.config >= 5.2.0
BuildRequires: python3-module-oslo.context >= 2.21.0
BuildRequires: python3-module-oslo.i18n >= 3.20.0
BuildRequires: python3-module-oslo.utils >= 3.36.0
BuildRequires: python3-module-oslo.serialization >= 2.25.0
BuildRequires: python3-module-debtcollector >= 1.19.0
BuildRequires: python3-module-pyinotify >= 0.9.6
BuildRequires: python3-module-dateutil >= 2.7.0

%if_with check
BuildRequires: python3-module-hacking >= 2.0.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-testtools >= 2.3.0
BuildRequires: python3-module-oslotest >= 3.3.0
BuildRequires: python3-module-coverage >= 4.5.1
BuildRequires: python3-module-bandit >= 1.6.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-pre-commit >= 2.6.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

Requires: python3-module-pbr >= 3.1.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-debtcollector >= 1.19.0
Requires: python3-module-pyinotify >= 0.9.6
Requires: python3-module-dateutil >= 2.7.0

%description
OpenStack logging configuration library provides standardized configuration for
all openstack projects. It also provides custom formatters, handlers and
support for context specific logging (like resource id's etc).

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-log-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version
%autopatch -p1

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/oslolog.1 %buildroot%_man1dir/oslolog.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/convert-json
%python3_sitelibdir/oslo_log
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/oslo_log/tests

%files tests
%python3_sitelibdir/oslo_log/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/oslolog.1.xz
%endif

%changelog
